/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.MemoryChecker;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MemoryCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"memoryCheck").executes(ctx -> MemoryCommand.run((CommandContext<CommandSourceStack>)ctx, 10))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> MemoryCommand.run((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"))));
    }

    private static int run(CommandContext<CommandSourceStack> context, int count) {
        if (!CrashUtils.SERVER_CONFIG.getMemoryChecker()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> CommandUtils.CreateTextComponent("Memory Checker not enabled in Config"), true);
            return 0;
        }
        List<MemoryChecker.MemoryCount> full = MemoryChecker.INSTANCE.counts;
        if (full.size() < count) {
            count = full.size();
        }
        int i = full.size() - count;
        while (i < full.size()) {
            int finalI = i++;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> MemoryCommand.createVisualMemoryText((MemoryChecker.MemoryCount)full.get(finalI)), true);
        }
        return 1;
    }

    private static Component createVisualMemoryText(MemoryChecker.MemoryCount count) {
        MutableComponent text = CommandUtils.CreateTextComponent("[");
        double maximum = Math.ceil(MemoryChecker.inGigaBytes(count.getMaximum()));
        double total = MemoryChecker.inGigaBytes(count.getTotal());
        double used = total - MemoryChecker.inGigaBytes(count.getFree());
        double percentTotal = total / maximum;
        double percentUsed = used / maximum;
        for (double i = 0.1; i <= 1.0; i += 0.1) {
            if (i < percentUsed) {
                text.m_7220_((Component)CommandUtils.coloredComponent("I", ChatFormatting.RED));
                continue;
            }
            if (i < percentTotal) {
                text.m_7220_((Component)CommandUtils.coloredComponent("I", ChatFormatting.YELLOW));
                continue;
            }
            text.m_7220_((Component)CommandUtils.coloredComponent("I", ChatFormatting.GREEN));
        }
        int usedpercent = (int)(percentUsed * 100.0);
        int allocatedpercent = (int)(percentTotal * 100.0);
        text.m_7220_((Component)CommandUtils.coloredComponent("] " + usedpercent + " % Used " + allocatedpercent + " % Allocated", ChatFormatting.WHITE));
        return text;
    }
}

