/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.world;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;
import tamaized.voidscape.Voidscape;
import tamaized.voidscape.block.PortalBlock;
import tamaized.voidscape.registry.ModBlocks;
import tamaized.voidscape.registry.ModPOIs;

public final class VoidPortalTeleporter
implements ITeleporter {
    public static final VoidPortalTeleporter INSTANCE = new VoidPortalTeleporter();

    private VoidPortalTeleporter() {
    }

    public Entity placeEntity(Entity oldEntity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        oldEntity.f_19789_ = 0.0f;
        return repositionEntity.apply(false);
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity oldEntity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        if (!Voidscape.checkForVoidDimension(oldEntity.m_9236_()) && !Voidscape.checkForVoidDimension((Level)destWorld)) {
            return null;
        }
        WorldBorder border = destWorld.m_6857_();
        double minX = Math.max(-2.9999872E7, border.m_61955_() + 16.0);
        double minZ = Math.max(-2.9999872E7, border.m_61956_() + 16.0);
        double maxX = Math.min(2.9999872E7, border.m_61957_() - 16.0);
        double maxZ = Math.min(2.9999872E7, border.m_61958_() - 16.0);
        double offset = DimensionType.m_63908_((DimensionType)oldEntity.m_9236_().m_6042_(), (DimensionType)destWorld.m_6042_());
        BlockPos blockpos = BlockPos.m_274561_((double)Mth.m_14008_((double)(oldEntity.m_20185_() * offset), (double)minX, (double)maxX), (double)oldEntity.m_20186_(), (double)Mth.m_14008_((double)(oldEntity.m_20189_() * offset), (double)minZ, (double)maxZ));
        return this.getPortalLogic(destWorld, oldEntity, blockpos).map(portalresult -> PortalShape.m_257966_((ServerLevel)destWorld, (BlockUtil.FoundRectangle)portalresult, (Direction.Axis)Direction.Axis.X, (Vec3)new Vec3(0.0, 0.0, 1.0), (Entity)oldEntity, (Vec3)oldEntity.m_20184_(), (float)oldEntity.m_146908_(), (float)oldEntity.m_146909_())).orElse(null);
    }

    private Optional<BlockUtil.FoundRectangle> getPortalLogic(ServerLevel level, Entity entity, BlockPos pos) {
        Optional<BlockUtil.FoundRectangle> existing = this.getExistingPortal(level, pos);
        if (entity instanceof ServerPlayer) {
            if (existing.isPresent()) {
                return existing;
            }
            return this.makePortal((Level)level, pos, entity.m_9236_().m_8055_(entity.m_20183_()).m_61145_(PortalBlock.AXIS).orElse(Direction.Axis.X));
        }
        return existing;
    }

    public Optional<BlockUtil.FoundRectangle> getExistingPortal(ServerLevel level, BlockPos pos) {
        PoiManager poimanager = level.m_8904_();
        int i = 64;
        poimanager.m_27056_((LevelReader)level, pos, i);
        Optional<PoiRecord> optional = poimanager.m_27166_(type -> type.m_203565_(ModPOIs.PORTAL.getKey()), pos, i, PoiManager.Occupancy.ANY).sorted(Comparator.comparingDouble(poi -> poi.m_27257_().m_123331_((Vec3i)pos)).thenComparingInt(poi -> poi.m_27257_().m_123342_())).filter(poi -> level.m_8055_(poi.m_27257_()).m_61138_((Property)BlockStateProperties.f_61364_)).findFirst();
        return optional.map(poi -> {
            BlockPos blockpos = poi.m_27257_();
            level.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(blockpos), 3, (Object)blockpos);
            BlockState blockstate = level.m_8055_(blockpos);
            return BlockUtil.m_124334_((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, posIn -> level.m_8055_(posIn) == blockstate);
        });
    }

    public Optional<BlockUtil.FoundRectangle> makePortal(Level level, BlockPos pos, Direction.Axis axis) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder border = level.m_6857_();
        int height = level.m_141928_() - 1;
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (BlockPos.MutableBlockPos mut : BlockPos.m_121935_((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(height, level.m_6924_(Heightmap.Types.MOTION_BLOCKING, mut.m_123341_(), mut.m_123343_()));
            if (!border.m_61937_((BlockPos)mut) || !border.m_61937_((BlockPos)mut.m_122175_(direction, 1))) continue;
            mut.m_122175_(direction.m_122424_(), 1);
            for (int l = j; l >= 0; --l) {
                int j1;
                mut.m_142448_(l);
                if (!level.m_46859_((BlockPos)mut)) continue;
                int i1 = l;
                while (l > 0 && level.m_46859_((BlockPos)mut.m_122173_(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > height || (j1 = i1 - l) > 0 && j1 < 3) continue;
                mut.m_142448_(l);
                if (!this.checkRegionForPlacement(level, (BlockPos)mut, mutable, direction, 0)) continue;
                double d2 = pos.m_123331_((Vec3i)mut);
                if (this.checkRegionForPlacement(level, (BlockPos)mut, mutable, direction, -1) && this.checkRegionForPlacement(level, (BlockPos)mut, mutable, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = mut.m_7949_();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = mut.m_7949_();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            blockpos = new BlockPos(pos.m_123341_(), Mth.m_14045_((int)pos.m_123342_(), (int)70, (int)(level.m_141928_() - 10)), pos.m_123343_()).m_7949_();
            Direction drotated = direction.m_122427_();
            if (!border.m_61937_(blockpos)) {
                return Optional.empty();
            }
            for (int fOffset = -1; fOffset < 2; ++fOffset) {
                for (int fWidth = 0; fWidth < 2; ++fWidth) {
                    for (int fHeight = -1; fHeight < 3; ++fHeight) {
                        boolean flag = fHeight < 0;
                        mutable.m_122154_((Vec3i)blockpos, fWidth * direction.m_122429_() + fOffset * drotated.m_122429_(), fHeight, fWidth * direction.m_122431_() + fOffset * direction.m_122431_());
                        level.m_46597_((BlockPos)mutable, flag ? ((Block)ModBlocks.FRAGILE_VOIDIC_CRYSTAL_BLOCK.get()).m_49966_() : Blocks.f_50016_.m_49966_());
                    }
                }
            }
        }
        for (int fWidth = -1; fWidth < 3; ++fWidth) {
            for (int fHeight = -1; fHeight < 4; ++fHeight) {
                if (fWidth != -1 && fWidth != 2 && fHeight != -1 && fHeight != 3) continue;
                mutable.m_122154_((Vec3i)blockpos, fWidth * direction.m_122429_(), fHeight, fWidth * direction.m_122431_());
                level.m_46597_((BlockPos)mutable, ((Block)ModBlocks.FRAGILE_VOIDIC_CRYSTAL_BLOCK.get()).m_49966_());
            }
        }
        BlockState portal = (BlockState)((PortalBlock)((Object)ModBlocks.PORTAL.get())).m_49966_().m_61124_(PortalBlock.AXIS, (Comparable)axis);
        for (int pWidth = 0; pWidth < 2; ++pWidth) {
            for (int pHeight = 0; pHeight < 3; ++pHeight) {
                mutable.m_122154_((Vec3i)blockpos, pWidth * direction.m_122429_(), pHeight, pWidth * direction.m_122431_());
                level.m_7731_((BlockPos)mutable, portal, 18);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(blockpos.m_7949_(), 2, 3));
    }

    private boolean checkRegionForPlacement(Level level, BlockPos originalPos, BlockPos.MutableBlockPos offsetPos, Direction directionIn, int offsetScale) {
        Direction direction = directionIn.m_122427_();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                offsetPos.m_122154_((Vec3i)originalPos, directionIn.m_122429_() * i + direction.m_122429_() * offsetScale, j, directionIn.m_122431_() * i + direction.m_122431_() * offsetScale);
                if (j < 0 && !level.m_8055_((BlockPos)offsetPos).m_280296_()) {
                    return false;
                }
                if (j < 0 || level.m_46859_((BlockPos)offsetPos)) continue;
                return false;
            }
        }
        return true;
    }
}

