/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import tamaized.voidscape.client.ClientUtil;
import tamaized.voidscape.network.DonatorHandler;
import tamaized.voidscape.network.client.ClientPacketNoFlashOnSetHealth;
import tamaized.voidscape.network.client.ClientPacketSendParticles;
import tamaized.voidscape.network.client.ClientPacketSubCapSync;
import tamaized.voidscape.network.server.ServerPacketHandlerDonatorSettings;

public class NetworkMessages {
    private static int index = 0;

    public static void register(SimpleChannel network) {
        NetworkMessages.registerMessage(network, ServerPacketHandlerDonatorSettings.class, () -> new ServerPacketHandlerDonatorSettings(new DonatorHandler.DonatorSettings(false, 0)));
        NetworkMessages.registerMessage(network, ClientPacketNoFlashOnSetHealth.class, ClientPacketNoFlashOnSetHealth::new);
        NetworkMessages.registerMessage(network, ClientPacketSubCapSync.class, ClientPacketSubCapSync::new);
        NetworkMessages.registerMessage(network, ClientPacketSendParticles.class, ClientPacketSendParticles::new);
    }

    private static <M extends IMessage<M>> void registerMessage(SimpleChannel network, Class<M> type, Supplier<M> factory) {
        network.registerMessage(index++, type, IMessage::encode, p -> IMessage.decode(p, factory), IMessage::onMessage);
    }

    public static interface IMessage<SELF extends IMessage<SELF>> {
        public static <M extends IMessage<M>> void encode(M message, FriendlyByteBuf packet) {
            message.toBytes(packet);
        }

        public static <M extends IMessage<M>> M decode(FriendlyByteBuf packet, Supplier<M> factory) {
            return (M)((IMessage)factory.get()).fromBytes(packet);
        }

        public static <M extends IMessage<M>> void onMessage(M message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> message.handle(IMessage.getSidedPlayer((Player)((NetworkEvent.Context)context.get()).getSender())));
            context.get().setPacketHandled(true);
        }

        @Nullable
        public static Player getSidedPlayer(@Nullable Player test) {
            return test == null ? ClientUtil.getClientPlayerSafely() : test;
        }

        public void handle(@Nullable Player var1);

        public void toBytes(FriendlyByteBuf var1);

        public SELF fromBytes(FriendlyByteBuf var1);
    }
}

