/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.entity;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import tamaized.voidscape.Voidscape;
import tamaized.voidscape.entity.IEthereal;
import tamaized.voidscape.entity.ai.nullservant.SpecialAugmentGoal;
import tamaized.voidscape.network.client.ClientPacketSendParticles;
import tamaized.voidscape.registry.ModAdvancementTriggers;
import tamaized.voidscape.registry.ModAttributes;
import tamaized.voidscape.registry.ModEntities;
import tamaized.voidscape.registry.ModItems;
import tamaized.voidscape.registry.ModTools;

public class NullServantEntity
extends Monster
implements IEthereal {
    private static final EntityDataAccessor<Integer> AUGMENT = SynchedEntityData.m_135353_(NullServantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> AUGMENT_ATTACK = SynchedEntityData.m_135353_(NullServantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Vector3f> AUGMENT_ATTACK_AOE1 = SynchedEntityData.m_135353_(NullServantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Vector3f> AUGMENT_ATTACK_AOE2 = SynchedEntityData.m_135353_(NullServantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final int AUGMENT_TITANITE = 1;
    public static final int AUGMENT_ICHOR = 2;
    public static final int AUGMENT_ASTRAL = 3;
    private static final UUID AUGMENT_HEALTH = UUID.fromString("f65da6bd-3e6b-468a-addc-a08335a954f2");
    private static final UUID AUGMENT_ATTACK_DAMAGE = UUID.fromString("5ae68488-df12-40c6-9517-357917341afa");
    private static final UUID AUGMENT_RESISTANCE = UUID.fromString("dcf3c0df-c827-43f7-8d07-9d77b6ce0c83");
    private ServerBossEvent bossInfo;

    public NullServantEntity(Level level) {
        this((EntityType<? extends NullServantEntity>)((EntityType)ModEntities.NULL_SERVANT.get()), level);
    }

    public NullServantEntity(EntityType<? extends NullServantEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = 25;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22277_, 15.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_((Attribute)ModAttributes.VOIDIC_DMG.get(), 2.0).m_22268_((Attribute)ModAttributes.VOIDIC_RES.get(), 3.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SpecialAugmentGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Deprecated
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33282_, DifficultyInstance p_33283_, MobSpawnType p_33284_, @Nullable SpawnGroupData p_33285_, @Nullable CompoundTag p_33286_) {
        this.m_213945_(this.m_217043_(), p_33283_);
        this.m_213946_(this.m_217043_(), p_33283_);
        return super.m_6518_(p_33282_, p_33283_, p_33284_, p_33285_, p_33286_);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance p_32136_) {
        super.m_213945_(random, p_32136_);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack(random.m_188499_() ? (ItemLike)ModTools.CORRUPT_AXE.get() : (ItemLike)ModTools.CORRUPT_SWORD.get()));
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (!this.m_9236_().m_5776_() && this.getAugment() <= 0) {
            if (pPlayer.m_21120_(pHand).m_150930_((Item)ModItems.TITANITE_CHUNK.get())) {
                this.doAugment(1, pPlayer, pHand);
                return InteractionResult.SUCCESS;
            }
            if (pPlayer.m_21120_(pHand).m_150930_((Item)ModItems.ICHOR.get())) {
                this.doAugment(2, pPlayer, pHand);
                return InteractionResult.SUCCESS;
            }
            if (pPlayer.m_21120_(pHand).m_150930_((Item)ModItems.ASTRAL_ESSENCE.get())) {
                this.doAugment(3, pPlayer, pHand);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    private void doAugment(int augment, Player player, InteractionHand hand) {
        this.setAugment(augment);
        this.doAugmentEffectsAndTrackBossBar();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModAdvancementTriggers.ITEM_USED_ON_NULL_SERVANT_TRIGGER.trigger(serverPlayer, player.m_21120_(hand));
        }
        if (!player.m_7500_()) {
            player.m_21120_(hand).m_41774_(1);
        }
    }

    private void doAugmentEffectsAndTrackBossBar() {
        ClientPacketSendParticles particles = new ClientPacketSendParticles();
        for (int i = 0; i < 100; ++i) {
            particles.queueParticle((ParticleOptions)ParticleTypes.f_123810_, false, this.m_20182_().m_7096_() - 1.0 + (double)this.m_217043_().m_188501_() * 2.0, this.m_20182_().m_7098_() + 0.5 + (double)this.m_217043_().m_188501_() * 2.0, this.m_20182_().m_7094_() - 1.0 + (double)this.m_217043_().m_188501_() * 2.0, 0.0, 0.0, 0.0);
        }
        Voidscape.NETWORK.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)particles);
        this.m_5496_(SoundEvents.f_12616_, 4.0f, 0.5f + this.m_217043_().m_188501_() * 0.5f);
        ChunkSource chunkSource = this.m_20193_().m_7726_();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache serverChunkCache = (ServerChunkCache)chunkSource;
            for (ServerPlayerConnection serverplayerconnection : ((ChunkMap.TrackedEntity)serverChunkCache.f_8325_.f_140150_.get((int)this.m_19879_())).f_140475_) {
                this.bossInfo.m_6543_(serverplayerconnection.m_142253_());
            }
        }
    }

    private void initBossBar() {
        if (this.getAugment() == 1) {
            this.bossInfo = new ServerBossEvent((Component)Component.m_237115_((String)"entity.voidscape.null_servant.titanite"), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS);
        } else if (this.getAugment() == 2) {
            this.bossInfo = new ServerBossEvent((Component)Component.m_237115_((String)"entity.voidscape.null_servant.ichor"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
        } else if (this.getAugment() == 3) {
            this.bossInfo = new ServerBossEvent((Component)Component.m_237115_((String)"entity.voidscape.null_servant.astral"), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS);
        }
    }

    private void setupAugmentStats() {
        AttributeInstance attributeMaxHealth = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attributeVoidicDamage = this.m_21051_((Attribute)ModAttributes.VOIDIC_DMG.get());
        AttributeInstance attributeVoidicRes = this.m_21051_((Attribute)ModAttributes.VOIDIC_RES.get());
        if (attributeMaxHealth == null || attributeVoidicDamage == null || attributeVoidicRes == null) {
            return;
        }
        attributeMaxHealth.m_22120_(AUGMENT_HEALTH);
        attributeVoidicDamage.m_22120_(AUGMENT_ATTACK_DAMAGE);
        attributeVoidicRes.m_22120_(AUGMENT_RESISTANCE);
        if (this.getAugment() == 1) {
            attributeMaxHealth.m_22118_(new AttributeModifier(AUGMENT_HEALTH, "Augmented Health", 50.0, AttributeModifier.Operation.ADDITION));
            attributeVoidicDamage.m_22118_(new AttributeModifier(AUGMENT_ATTACK_DAMAGE, "Augmented Damage", 1.0, AttributeModifier.Operation.ADDITION));
            attributeVoidicRes.m_22118_(new AttributeModifier(AUGMENT_RESISTANCE, "Augmented Resistance", 1.0, AttributeModifier.Operation.ADDITION));
            ItemStack stack = ItemStack.f_41583_;
            if (this.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ModTools.CORRUPT_SWORD.get())) {
                stack = new ItemStack((ItemLike)ModTools.TITANITE_SWORD.get());
            } else if (this.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ModTools.CORRUPT_AXE.get())) {
                stack = new ItemStack((ItemLike)ModTools.TITANITE_AXE.get());
            }
            if (!stack.m_41619_()) {
                this.m_8061_(EquipmentSlot.MAINHAND, stack);
            }
        } else if (this.getAugment() == 2) {
            attributeMaxHealth.m_22118_(new AttributeModifier(AUGMENT_HEALTH, "Augmented Health", 150.0, AttributeModifier.Operation.ADDITION));
            attributeVoidicDamage.m_22118_(new AttributeModifier(AUGMENT_ATTACK_DAMAGE, "Augmented Damage", 4.0, AttributeModifier.Operation.ADDITION));
            attributeVoidicRes.m_22118_(new AttributeModifier(AUGMENT_RESISTANCE, "Augmented Resistance", 2.0, AttributeModifier.Operation.ADDITION));
            ItemStack stack = ItemStack.f_41583_;
            if (this.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ModTools.CORRUPT_SWORD.get())) {
                stack = new ItemStack((ItemLike)ModTools.ICHOR_SWORD.get());
            } else if (this.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ModTools.CORRUPT_AXE.get())) {
                stack = new ItemStack((ItemLike)ModTools.ICHOR_AXE.get());
            }
            if (!stack.m_41619_()) {
                this.m_8061_(EquipmentSlot.MAINHAND, stack);
            }
        } else if (this.getAugment() == 3) {
            attributeMaxHealth.m_22118_(new AttributeModifier(AUGMENT_HEALTH, "Augmented Health", 400.0, AttributeModifier.Operation.ADDITION));
            attributeVoidicDamage.m_22118_(new AttributeModifier(AUGMENT_ATTACK_DAMAGE, "Augmented Damage", 8.0, AttributeModifier.Operation.ADDITION));
            attributeVoidicRes.m_22118_(new AttributeModifier(AUGMENT_RESISTANCE, "Augmented Resistance", 4.0, AttributeModifier.Operation.ADDITION));
            ItemStack stack = ItemStack.f_41583_;
            if (this.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ModTools.CORRUPT_SWORD.get())) {
                stack = new ItemStack((ItemLike)ModTools.ASTRAL_SWORD.get());
            } else if (this.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ModTools.CORRUPT_AXE.get())) {
                stack = new ItemStack((ItemLike)ModTools.ASTRAL_AXE.get());
            }
            if (!stack.m_41619_()) {
                this.m_8061_(EquipmentSlot.MAINHAND, stack);
            }
        }
        this.m_21153_(this.m_21233_());
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        if (this.bossInfo != null) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        if (this.bossInfo != null) {
            this.bossInfo.m_6543_(player);
        }
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        if (this.bossInfo != null) {
            this.bossInfo.m_6539_(player);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_() && this.bossInfo != null) {
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AUGMENT, (Object)0);
        this.f_19804_.m_135372_(AUGMENT_ATTACK, (Object)false);
        this.f_19804_.m_135372_(AUGMENT_ATTACK_AOE1, (Object)new Vector3f());
        this.f_19804_.m_135372_(AUGMENT_ATTACK_AOE2, (Object)new Vector3f());
    }

    public Integer getAugment() {
        return (Integer)this.f_19804_.m_135370_(AUGMENT);
    }

    public void setAugment(int type) {
        this.f_19804_.m_135381_(AUGMENT, (Object)type);
        if (type > 0) {
            this.initBossBar();
            this.setupAugmentStats();
        }
    }

    public Boolean getAugmentAttack() {
        return (Boolean)this.f_19804_.m_135370_(AUGMENT_ATTACK);
    }

    public void setAugmentAttack(boolean attack) {
        this.f_19804_.m_135381_(AUGMENT_ATTACK, (Object)attack);
    }

    public void setAugmentAttackAoes(Vector3f aoe1, Vector3f aoe2) {
        this.f_19804_.m_135381_(AUGMENT_ATTACK_AOE1, (Object)aoe1);
        this.f_19804_.m_135381_(AUGMENT_ATTACK_AOE2, (Object)aoe2);
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128405_("augment", this.getAugment().intValue());
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        this.setAugment(compound.m_128451_("augment"));
        super.m_7378_(compound);
        if (this.m_8077_() && this.bossInfo != null) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    protected void m_7472_(DamageSource p_21385_, int p_21386_, boolean p_21387_) {
        if (this.getAugment() == 1) {
            this.m_19983_(new ItemStack((ItemLike)ModItems.TITANITE_SHARD.get()));
        } else if (this.getAugment() == 2) {
            this.m_19983_(new ItemStack((ItemLike)ModItems.ICHOR_CRYSTAL.get()));
        } else if (this.getAugment() == 3) {
            this.m_19983_(new ItemStack((ItemLike)ModItems.ASTRAL_CRYSTAL.get()));
        }
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource p_33579_) {
        return SoundEvents.f_11704_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11703_;
    }

    protected void m_7355_(BlockPos p_32159_, BlockState p_32160_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_144049_;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return this.getAugmentAttack() == false && super.m_6469_(pSource, pAmount);
    }

    public void m_147240_(double pStrength, double pX, double pZ) {
    }

    protected boolean m_6107_() {
        return this.getAugmentAttack() == false && super.m_6107_();
    }

    public void m_7334_(Entity pEntity) {
        if (!this.getAugmentAttack().booleanValue()) {
            super.m_7334_(pEntity);
        }
    }

    public void m_5997_(double pX, double pY, double pZ) {
        if (!this.getAugmentAttack().booleanValue()) {
            super.m_5997_(pX, pY, pZ);
        }
    }

    public boolean m_5829_() {
        return this.getAugmentAttack() == false && super.m_5829_();
    }

    public boolean m_7337_(Entity pEntity) {
        return this.getAugmentAttack() == false && super.m_7337_(pEntity);
    }

    protected void m_6138_() {
        if (!this.getAugmentAttack().booleanValue()) {
            super.m_6138_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            if (this.f_19797_ % 5 == 0) {
                Vec3 vec = this.m_20182_().m_82520_(0.0, (double)(1.0f - this.f_19796_.m_188501_() * 0.6f), 0.0).m_82549_(new Vec3(0.1 + this.f_19796_.m_188500_() * 0.35, 0.0, 0.0).m_82524_((float)Math.toRadians(this.f_19796_.m_188503_(360))));
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
            }
            if (this.getAugmentAttack().booleanValue()) {
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123810_, false, this.m_20182_().m_7096_() - 1.0 + (double)this.m_217043_().m_188501_() * 2.0, this.m_20182_().m_7098_() + 0.5 + (double)this.m_217043_().m_188501_() * 2.0, this.m_20182_().m_7094_() - 1.0 + (double)this.m_217043_().m_188501_() * 2.0, 0.0, 0.0, 0.0);
            }
            for (int i = 0; i < 3; ++i) {
                this.doAoeParticles((Vector3f)this.f_19804_.m_135370_(AUGMENT_ATTACK_AOE1));
                this.doAoeParticles((Vector3f)this.f_19804_.m_135370_(AUGMENT_ATTACK_AOE2));
            }
        }
    }

    private void doAoeParticles(Vector3f aoe) {
        if (aoe.x() != 0.0f || aoe.y() != 0.0f || aoe.z() != 0.0f) {
            Vec3 rot = new Vec3(4.0, 0.0, 0.0).m_82524_((float)Math.toRadians(this.m_217043_().m_188501_() * 360.0f)).m_82496_((float)Math.toRadians(this.m_217043_().m_188501_() * 360.0f));
            Vec3 pos = new Vec3(aoe).m_82549_(rot);
            Vec3 dir = new Vec3((double)aoe.x(), (double)aoe.y(), (double)aoe.z()).m_82546_(pos).m_82541_().m_82490_(0.35);
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123810_, false, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), dir.m_7096_(), dir.m_7098_(), dir.m_7094_());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

