/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mods.railcraft.api.core.NetworkSerializable;
import mods.railcraft.world.module.Module;
import mods.railcraft.world.module.SharedModule;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.INBTSerializable;

public class ModuleDispatcher
implements NetworkSerializable,
INBTSerializable<CompoundTag> {
    private final Map<String, Module> moduleByName = new HashMap<String, Module>();
    private final Map<Class<?>, Module> moduleByType = new HashMap();

    public <T extends Module> T registerModule(String name, T module) {
        if (this.moduleByName.put(name, module) != null) {
            throw new IllegalStateException("Module already registered with name: " + name);
        }
        Class<?> clazz = module.getClass();
        do {
            if (clazz.isAnnotationPresent(SharedModule.class) || this.moduleByType.put(clazz, module) == null) continue;
            throw new IllegalStateException("Module already registered with type: " + clazz.getName());
        } while (Module.class.isAssignableFrom(clazz = clazz.getSuperclass()));
        return module;
    }

    public <T> Optional<T> getModule(Class<T> type) {
        return Optional.ofNullable(this.moduleByType.get(type));
    }

    public void serverTick() {
        this.moduleByName.values().forEach(Module::serverTick);
    }

    @Override
    public void writeToBuf(FriendlyByteBuf out) {
        out.m_236831_(this.moduleByName, FriendlyByteBuf::m_130070_, (buf, module) -> module.writeToBuf((FriendlyByteBuf)buf));
    }

    @Override
    public void readFromBuf(FriendlyByteBuf in) {
        int size = in.m_130242_();
        for (int i = 0; i < size; ++i) {
            String name = in.m_130277_();
            Module module = this.moduleByName.get(name);
            if (module == null) {
                throw new IllegalStateException("Missing module: " + name);
            }
            module.readFromBuf(in);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.moduleByName.forEach((name, module) -> tag.m_128365_(name, (Tag)module.serializeNBT()));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128456_()) {
            return;
        }
        this.moduleByName.forEach((name, module) -> {
            CompoundTag moduleTag = tag.m_128469_(name);
            if (!moduleTag.m_128456_()) {
                module.deserializeNBT(moduleTag);
            }
        });
    }
}

