/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.worldspike;

import mods.railcraft.Translations;
import mods.railcraft.integrations.jei.JeiSearchable;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.worldspike.WorldSpikeBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.world.ForgeChunkManager;
import org.jetbrains.annotations.Nullable;

public class WorldSpikeBlock
extends BaseEntityBlock
implements JeiSearchable {
    public WorldSpikeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.m_6807_(state, level, pos, oldState, movedByPiston);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.forceChunk(serverLevel, pos, true);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.m_6810_(state, level, pos, oldState, movedByPiston);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!state.m_60713_(oldState.m_60734_())) {
                this.forceChunk(serverLevel, pos, false);
            }
        }
    }

    private void forceChunk(ServerLevel serverLevel, BlockPos pos, boolean add) {
        ChunkPos chunkPos = new ChunkPos(pos);
        for (int x = chunkPos.f_45578_ - 1; x <= chunkPos.f_45578_ + 1; ++x) {
            for (int z = chunkPos.f_45579_ - 1; z <= chunkPos.f_45579_ + 1; ++z) {
                ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"railcraft", (BlockPos)pos, (int)x, (int)z, (boolean)add, (boolean)false);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new WorldSpikeBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.m_5776_() ? null : WorldSpikeBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.WORLD_SPIKE.get()), WorldSpikeBlockEntity::serverTick);
    }

    @Override
    public Component jeiDescription() {
        return Component.m_237115_((String)Translations.Jei.WORLD_SPIKE);
    }
}

