/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.util.FunctionalUtil;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.level.block.track.outfitted.PoweredOutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class LocomotiveTrackBlock
extends PoweredOutfittedTrackBlock {
    public static final Property<Locomotive.Mode> LOCOMOTIVE_MODE = EnumProperty.m_61587_((String)"locomotive_mode", Locomotive.Mode.class);

    public LocomotiveTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)super.buildDefaultState(blockState).m_61124_(LOCOMOTIVE_MODE, (Comparable)((Object)Locomotive.Mode.SHUTDOWN));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LOCOMOTIVE_MODE});
    }

    @Override
    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        super.onMinecartPass(state, level, pos, cart);
        if (LocomotiveTrackBlock.isPowered(state)) {
            RollingStock.getOrThrow(cart).train().entities().flatMap(FunctionalUtil.ofType(Locomotive.class)).forEach(locomotive -> locomotive.setMode((Locomotive.Mode)((Object)((Object)state.m_61143_(LOCOMOTIVE_MODE)))));
        }
    }

    @Override
    protected boolean crowbarWhack(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack itemStack) {
        Locomotive.Mode mode = LocomotiveTrackBlock.getMode(state);
        Locomotive.Mode newMode = player.m_6047_() ? mode.previous() : mode.next();
        boolean res = level.m_46597_(pos, (BlockState)state.m_61124_(LOCOMOTIVE_MODE, (Comparable)((Object)newMode)));
        MutableComponent currentMode = Component.m_237115_((String)Translations.Tips.CURRENT_MODE);
        MutableComponent modeDisplay = newMode.getDisplayName().m_6881_().m_130940_(ChatFormatting.DARK_PURPLE);
        player.m_5661_((Component)currentMode.m_130946_(" ").m_7220_((Component)modeDisplay), true);
        return res;
    }

    @Override
    public int getPowerPropagation(BlockState blockState, Level level, BlockPos blockPos) {
        return 8;
    }

    public static Locomotive.Mode getMode(BlockState blockState) {
        return (Locomotive.Mode)((Object)blockState.m_61143_(LOCOMOTIVE_MODE));
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.m_237115_((String)Translations.Tips.LOCOMOTIVE_TRACK).m_130940_(ChatFormatting.GRAY));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.HIT_CROWBAR_TO_CHANGE_MODE).m_130940_(ChatFormatting.BLUE));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.APPLY_REDSTONE_TO_ENABLE).m_130940_(ChatFormatting.RED));
    }
}

