/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.jei;

import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import org.jetbrains.annotations.Nullable;

public class DefaultRecipeWrapper
implements ICraftingCategoryExtension {
    private final CustomRecipe recipe;
    private final boolean isShapeless;
    private final Component info;
    private Consumer<ItemStack> stackModifier;

    DefaultRecipeWrapper(CustomRecipe recipe, boolean isShapeless, Component info) {
        this.recipe = recipe;
        this.isShapeless = isShapeless;
        this.info = info;
        this.stackModifier = stack -> {};
    }

    DefaultRecipeWrapper modifyInputs(Consumer<ItemStack> stackModifier) {
        this.stackModifier = stackModifier;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.recipe.m_6423_();
    }

    public void drawInfo(int recipeWidth, int recipeHeight, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        int stringWidth = font.m_92852_((FormattedText)this.info) / 2;
        guiGraphics.m_280614_(font, this.info, 82 - stringWidth, 0, -8355712, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        List<List> inputs = this.recipe.m_7527_().stream().map(ingredient -> List.of(ingredient.m_43908_())).toList();
        inputs.forEach(l -> l.forEach(this.stackModifier));
        RegistryAccess registryAccess = Minecraft.m_91087_().f_91073_.m_9598_();
        craftingGridHelper.createAndSetOutputs(builder, List.of(this.recipe.m_8043_(registryAccess)));
        craftingGridHelper.createAndSetInputs(builder, inputs, this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        return this.isShapeless ? 0 : 3;
    }

    public int getHeight() {
        return this.isShapeless ? 0 : 3;
    }
}

