/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.spell;

import elucent.eidolon.api.deity.Deity;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.capability.ISoul;
import elucent.eidolon.common.block.GhostLight;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.common.spell.StaticSpell;
import elucent.eidolon.registries.Registry;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;

public class LightSpell
extends StaticSpell {
    final Deity deity;

    public LightSpell(ResourceLocation name, Deity deity, Sign ... signs) {
        super(name, 3, signs);
        this.deity = deity;
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        AtomicReference<Boolean> favor = new AtomicReference<Boolean>(Boolean.FALSE);
        world.getCapability(IReputation.INSTANCE).ifPresent(reputation -> favor.set(reputation.getReputation(player, this.deity.getId()) >= 3.0));
        return favor.get();
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        EntityHitResult entityHitResult;
        Entity entity;
        HitResult ray = LightSpell.rayTrace((Entity)player, player.getBlockReach(), 0.0f, true);
        if (ray instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)ray;
            BlockPos blockPos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
            if (world.m_8055_(blockPos).m_247087_() && world.m_45752_(((Block)Registry.GHOST_LIGHT.get()).m_49966_(), blockPos, CollisionContext.m_82750_((Entity)player))) {
                BlockState lightBlockState = ((Block)Registry.GHOST_LIGHT.get()).m_49966_();
                if (this.deity.getId().equals((Object)Deities.DARK_DEITY_ID)) {
                    lightBlockState = (BlockState)lightBlockState.m_61124_((Property)GhostLight.DEITY, (Comparable)Boolean.valueOf(false));
                }
                world.m_46597_(blockPos, lightBlockState);
                world.m_7260_(blockPos, world.m_8055_(blockPos), world.m_8055_(blockPos), 2);
                ISoul.expendMana(player, this.getCost());
            }
        } else if (ray instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)ray).m_82443_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200));
            ISoul.expendMana(player, this.getCost());
        }
    }
}

