/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.capability;

import elucent.eidolon.capability.IPlayerData;
import elucent.eidolon.common.item.IWingsItem;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.WingsDashPacket;
import elucent.eidolon.network.WingsFlapPacket;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.INBTSerializable;

public class PlayerDataImpl
implements IPlayerData,
INBTSerializable<CompoundTag> {
    int wingCharges = 0;
    int dashTicks = 0;
    long lastFlapTime = 0L;
    long flightStartTime = 0L;
    boolean isFlying = false;
    static final AttributeModifier WINGS_SLOWFALL = new AttributeModifier(new UUID(4035878977813972397L, 2208061895106560443L), "Wings slow falling", -0.6, AttributeModifier.Operation.MULTIPLY_TOTAL);

    @Override
    public int getWingCharges(Player player) {
        return this.wingCharges;
    }

    @Override
    public void rechargeWings(Player player) {
        this.wingCharges = this.getMaxWingCharges(player);
    }

    @Override
    public boolean tryFlapWings(Player player) {
        if (this.wingCharges <= 0 || this.getWingsItem(player).m_41619_()) {
            this.wingCharges = 0;
            return false;
        }
        if (this.canFlap(player)) {
            --this.wingCharges;
            ItemStack wings = this.getWingsItem(player);
            Item item = wings.m_41720_();
            if (item instanceof IWingsItem) {
                IWingsItem i = (IWingsItem)item;
                if (this.isDashing(player)) {
                    i.onDashFlap(player, player.f_19853_, wings, this.getDashTicks(player));
                } else {
                    i.onFlap(player, player.f_19853_, wings, this.getDashTicks(player));
                }
                this.lastFlapTime = player.f_19853_.m_46467_();
                this.startFlying(player);
                if (player.f_19853_.f_46443_) {
                    Networking.sendToServer(new WingsFlapPacket(player));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int getDashTicks(Player player) {
        return this.dashTicks;
    }

    @Override
    public void doDashTick(Player player) {
        if (this.dashTicks > 0) {
            IWingsItem i;
            ItemStack wings = this.getWingsItem(player);
            Item item = wings.m_41720_();
            if (item instanceof IWingsItem) {
                i = (IWingsItem)item;
                i.onDashTick(player, player.f_19853_, wings, this.dashTicks);
            }
            --this.dashTicks;
            if (this.dashTicks == 0 && (item = wings.m_41720_()) instanceof IWingsItem) {
                i = (IWingsItem)item;
                i.onDashEnd(player, player.f_19853_, wings);
            }
        }
    }

    @Override
    public boolean tryDash(Player player) {
        if (this.wingCharges > 0 && this.canFlap(player)) {
            --this.wingCharges;
            ItemStack wings = this.getWingsItem(player);
            Item item = wings.m_41720_();
            if (item instanceof IWingsItem) {
                IWingsItem i = (IWingsItem)item;
                i.onDashStart(player, player.f_19853_, wings);
                this.lastFlapTime = player.f_19853_.m_46467_();
                if (!this.isFlying) {
                    this.flightStartTime = this.lastFlapTime;
                }
                this.isFlying = true;
                this.dashTicks = i.getDashTicks(wings);
                if (player.f_19853_.f_46443_) {
                    Networking.sendToServer(new WingsDashPacket(player));
                }
            }
            return true;
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("wingCharges", this.wingCharges);
        tag.m_128405_("dashTicks", this.dashTicks);
        tag.m_128356_("lastFlapTime", this.lastFlapTime);
        tag.m_128356_("flightStartTime", this.flightStartTime);
        tag.m_128379_("isFlying", this.isFlying);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.wingCharges = nbt.m_128451_("wingCharges");
        this.dashTicks = nbt.m_128451_("dashTicks");
        this.lastFlapTime = nbt.m_128454_("lastFlapTime");
        this.flightStartTime = nbt.m_128454_("flightStartTime");
        this.isFlying = nbt.m_128471_("isFlying");
    }

    @Override
    public long getLastFlapTime(Player player) {
        return this.lastFlapTime;
    }

    @Override
    public boolean isFlying(Player player) {
        return this.isFlying;
    }

    @Override
    public void startFlying(Player player) {
        if (!this.isFlying) {
            this.flightStartTime = player.f_19853_.m_46467_();
            this.isFlying = true;
            AttributeInstance attr = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            if (attr != null && !attr.m_22109_(WINGS_SLOWFALL)) {
                attr.m_22118_(WINGS_SLOWFALL);
            }
        }
    }

    @Override
    public void stopFlying(Player player) {
        if (this.isFlying) {
            this.isFlying = false;
            if (this.isDashing(player)) {
                this.setDashTicks(0);
                ItemStack wings = this.getWingsItem(player);
                Item item = wings.m_41720_();
                if (item instanceof IWingsItem) {
                    IWingsItem i = (IWingsItem)item;
                    i.onDashEnd(player, player.f_19853_, wings);
                }
            }
            this.flightStartTime = player.f_19853_.m_46467_();
            AttributeInstance attr = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            if (attr != null && attr.m_22109_(WINGS_SLOWFALL)) {
                attr.m_22130_(WINGS_SLOWFALL);
            }
        }
    }

    @Override
    public void setDashTicks(int ticks) {
        this.dashTicks = ticks;
    }

    @Override
    public void setLastFlapTime(long lastFlapTime) {
        this.lastFlapTime = lastFlapTime;
    }

    @Override
    public long getFlightStartTime(Player player) {
        return this.flightStartTime;
    }
}

