/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.capability;

import elucent.eidolon.api.spells.Rune;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.IKnowledge;
import elucent.eidolon.registries.Runes;
import elucent.eidolon.registries.Signs;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class KnowledgeImpl
implements IKnowledge,
INBTSerializable<CompoundTag> {
    final Set<Sign> signs = new HashSet<Sign>();
    final Set<ResourceLocation> facts = new HashSet<ResourceLocation>();
    final Set<ResourceLocation> researches = new HashSet<ResourceLocation>();
    final Set<Rune> runes = new HashSet<Rune>();

    @Override
    public boolean knowsSign(Sign sign) {
        return this.signs.contains(sign);
    }

    @Override
    public void addSign(Sign sign) {
        this.signs.add(sign);
    }

    @Override
    public void removeSign(Sign sign) {
        this.signs.remove(sign);
    }

    @Override
    public void resetSigns() {
        this.signs.clear();
    }

    @Override
    public Set<Sign> getKnownSigns() {
        return this.signs;
    }

    @Override
    public boolean knowsFact(ResourceLocation fact) {
        return this.facts.contains(fact);
    }

    @Override
    public void addFact(ResourceLocation fact) {
        this.facts.add(fact);
    }

    @Override
    public void removeFact(ResourceLocation fact) {
        this.facts.remove(fact);
    }

    @Override
    public void resetFacts() {
        this.facts.clear();
    }

    @Override
    public Set<ResourceLocation> getKnownFacts() {
        return this.facts;
    }

    @Override
    public boolean knowsResearch(ResourceLocation research) {
        return this.researches.contains(research);
    }

    @Override
    public void addResearch(ResourceLocation research) {
        this.researches.add(research);
    }

    @Override
    public void removeResearch(ResourceLocation research) {
        this.researches.remove(research);
    }

    @Override
    public void resetResearch() {
        this.researches.clear();
    }

    @Override
    public Set<ResourceLocation> getKnownResearches() {
        return this.researches;
    }

    @Override
    public boolean knowsRune(Rune rune) {
        return this.runes.contains(rune);
    }

    @Override
    public void addRune(Rune rune) {
        this.runes.add(rune);
    }

    @Override
    public void removeRune(Rune rune) {
        this.runes.remove(rune);
    }

    @Override
    public void resetRunes() {
        this.runes.clear();
    }

    @Override
    public Set<Rune> getKnownRunes() {
        return this.runes;
    }

    public CompoundTag serializeNBT() {
        ListTag signs = new ListTag();
        for (Sign sign : this.getKnownSigns()) {
            signs.add((Object)StringTag.m_129297_((String)sign.getRegistryName().toString()));
        }
        ListTag facts = new ListTag();
        for (ResourceLocation resourceLocation : this.getKnownFacts()) {
            facts.add((Object)StringTag.m_129297_((String)resourceLocation.toString()));
        }
        ListTag listTag = new ListTag();
        for (ResourceLocation resourceLocation : this.getKnownResearches()) {
            listTag.add((Object)StringTag.m_129297_((String)resourceLocation.toString()));
        }
        ListTag listTag2 = new ListTag();
        for (Rune r : this.getKnownRunes()) {
            listTag2.add((Object)StringTag.m_129297_((String)r.getRegistryName().toString()));
        }
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128365_("signs", (Tag)signs);
        compoundTag.m_128365_("facts", (Tag)facts);
        compoundTag.m_128365_("researches", (Tag)listTag);
        compoundTag.m_128365_("runes", (Tag)listTag2);
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ResourceLocation loc;
        int i;
        this.getKnownSigns().clear();
        this.getKnownFacts().clear();
        this.getKnownResearches().clear();
        this.getKnownRunes().clear();
        if (nbt.m_128441_("signs")) {
            ListTag signs = nbt.m_128437_("signs", 8);
            for (i = 0; i < signs.size(); ++i) {
                loc = new ResourceLocation(signs.m_128778_(i));
                Sign s = Signs.find(loc);
                if (s == null) continue;
                this.addSign(s);
            }
        }
        if (nbt.m_128441_("facts")) {
            ListTag facts = nbt.m_128437_("facts", 8);
            for (i = 0; i < facts.size(); ++i) {
                this.addFact(new ResourceLocation(facts.m_128778_(i)));
            }
        }
        if (nbt.m_128441_("researches")) {
            ListTag researches = nbt.m_128437_("researches", 8);
            for (i = 0; i < researches.size(); ++i) {
                this.addResearch(new ResourceLocation(researches.m_128778_(i)));
            }
        }
        if (nbt.m_128441_("runes")) {
            ListTag runes = nbt.m_128437_("runes", 8);
            for (i = 0; i < runes.size(); ++i) {
                loc = new ResourceLocation(runes.m_128778_(i));
                Rune r = Runes.find(loc);
                if (r == null) continue;
                this.addRune(r);
            }
        }
    }
}

