/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.container;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;

public abstract class ContainerScreenScrolling<T extends ScrollingInventoryContainer>
extends ContainerScreenExtended<T> {
    private static final int SEARCH_WIDTH = 89;
    private WidgetTextFieldExtended searchField = null;
    private WidgetScrollBar scrollbar = null;

    public ContainerScreenScrolling(T container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        if (this.isSearchEnabled()) {
            int searchWidth = this.getSearchWidth();
            int searchX = this.getSearchX();
            int searchY = this.getSearchY();
            if (this.searchField == null) {
                Objects.requireNonNull(this.f_96547_);
                this.searchField = new WidgetTextFieldExtended(this.f_96547_, this.f_97735_ + searchX, this.f_97736_ + searchY, searchWidth, 9, (Component)Component.m_237115_((String)"gui.cyclopscore.search"));
                this.searchField.m_94199_(64);
                this.searchField.m_94199_(15);
                this.searchField.m_94182_(false);
                this.searchField.m_94194_(true);
                this.searchField.m_94202_(0xFFFFFF);
                this.searchField.m_94190_(true);
                this.searchField.m_94144_("");
                this.searchField.m_93674_(searchWidth);
                this.searchField.m_252865_(this.f_97735_ + (searchX + searchWidth) - this.searchField.m_5711_());
            } else {
                this.searchField.m_93674_(searchWidth);
                this.searchField.m_252865_(this.f_97735_ + (searchX + searchWidth) - this.searchField.m_5711_());
                this.searchField.m_253211_(this.f_97736_ + searchY);
            }
            this.m_7787_((GuiEventListener)this.searchField);
        }
        if (this.scrollbar == null) {
            ((ScrollingInventoryContainer)this.m_6262_()).updateFilter("");
            this.scrollbar = new WidgetScrollBar(this.f_97735_ + this.getScrollX(), this.f_97736_ + this.getScrollY(), this.getScrollHeight(), (Component)Component.m_237115_((String)"gui.cyclopscore.scrollbar"), (WidgetScrollBar.IScrollCallback)this.m_6262_(), ((ScrollingInventoryContainer)this.m_6262_()).getPageSize(), this.getScrollRegion());
            this.scrollbar.setTotalRows(((ScrollingInventoryContainer)this.m_6262_()).getFilteredItemCount() / ((ScrollingInventoryContainer)this.m_6262_()).getColumns());
        }
        this.m_7787_((GuiEventListener)this.scrollbar);
        this.getScrollbar().scrollTo(this.scrollbar.getCurrentScroll());
    }

    protected Rectangle getScrollRegion() {
        return null;
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.searchField != null) {
            this.searchField.m_94120_();
        }
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (this.isSearchEnabled() && this.searchField.m_93696_()) {
            if (this.searchField.m_5534_(typedChar, keyCode)) {
                this.updateSearch(this.searchField.m_94155_());
            }
            return true;
        }
        return super.m_5534_(typedChar, keyCode);
    }

    public boolean m_7933_(int typedChar, int keyCode, int modifiers) {
        if (this.isSearchEnabled() && this.searchField.m_93696_() && typedChar != 256) {
            if (this.searchField.m_7933_(typedChar, keyCode, modifiers)) {
                this.updateSearch(this.searchField.m_94155_());
            }
            return true;
        }
        return super.m_7933_(typedChar, keyCode, modifiers);
    }

    @Override
    protected void drawCurrentScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isSubsetRenderSlots()) {
            NonNullList oldSlots = ((ScrollingInventoryContainer)this.container).f_38839_;
            int startIndex = ((ScrollingInventoryContainer)this.m_6262_()).getFirstElement();
            NonNullList newSlots = NonNullList.m_122779_();
            newSlots.addAll((Collection)oldSlots.subList(startIndex, Math.min(oldSlots.size(), startIndex + ((ScrollingInventoryContainer)this.m_6262_()).getPageSize() * ((ScrollingInventoryContainer)this.m_6262_()).getColumns())));
            newSlots.addAll((Collection)oldSlots.subList(((ScrollingInventoryContainer)this.m_6262_()).getUnfilteredItemCount(), oldSlots.size()));
            ((ScrollingInventoryContainer)this.container).f_38839_ = newSlots;
            super.drawCurrentScreen(guiGraphics, mouseX, mouseY, partialTicks);
            ((ScrollingInventoryContainer)this.container).f_38839_ = oldSlots;
        } else {
            super.drawCurrentScreen(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    protected boolean isSubsetRenderSlots() {
        return false;
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        if (this.isSearchEnabled()) {
            this.searchField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.scrollbar.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        if (this.m_7222_() != null && this.m_7282_() && mouseButton == 0 && this.m_7222_().m_7979_(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    protected void updateSearch(String searchString) {
        ((ScrollingInventoryContainer)this.m_6262_()).updateFilter(searchString);
        this.scrollbar.setTotalRows(((ScrollingInventoryContainer)this.m_6262_()).getFilteredItemCount() / ((ScrollingInventoryContainer)this.m_6262_()).getColumns());
        this.scrollbar.scrollTo(0.0f);
    }

    public EditBox getSearchField() {
        return this.searchField;
    }

    public WidgetScrollBar getScrollbar() {
        return this.scrollbar;
    }

    protected int getScrollX() {
        return 175;
    }

    protected int getScrollY() {
        return 18;
    }

    protected int getScrollHeight() {
        return 112;
    }

    protected boolean isSearchEnabled() {
        return true;
    }

    protected int getSearchX() {
        return 82;
    }

    protected int getSearchY() {
        return 6;
    }

    protected int getSearchWidth() {
        return 89;
    }
}

