/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.datagen;

import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IngredientCondition;
import com.teammoeg.caupona.data.recipes.conditions.Halfs;
import com.teammoeg.caupona.data.recipes.conditions.Mainly;
import com.teammoeg.caupona.data.recipes.conditions.MainlyOfType;
import com.teammoeg.caupona.data.recipes.conditions.Must;
import com.teammoeg.caupona.data.recipes.conditions.Only;
import com.teammoeg.caupona.datagen.IngredientNumberBuilder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class IngredientConditionsBuilder<T> {
    private T parent;
    private List<IngredientCondition> li;
    private List<IngredientCondition> al;
    private List<IngredientCondition> dy;

    public IngredientConditionsBuilder(T parent, List<IngredientCondition> cr, List<IngredientCondition> al, List<IngredientCondition> dy) {
        this.parent = parent;
        this.li = cr;
        this.al = al;
        this.dy = dy;
    }

    public IngredientNumberBuilder<T> half() {
        return new IngredientNumberBuilder(this, this::makeHalf);
    }

    private void makeHalf(CookIngredients sn) {
        this.li.add(new Halfs(sn));
    }

    public IngredientNumberBuilder<T> typeMainly(ResourceLocation rs) {
        return new IngredientNumberBuilder(this, sn -> this.li.add(new MainlyOfType((CookIngredients)sn, rs)));
    }

    public IngredientNumberBuilder<T> typeMainly(TagKey<Item> rs) {
        return this.typeMainly(rs.f_203868_());
    }

    public IngredientNumberBuilder<T> mainly() {
        return new IngredientNumberBuilder(this, this::makeMainly);
    }

    private void makeMainly(CookIngredients sn) {
        this.li.add(new Mainly(sn));
    }

    public IngredientNumberBuilder<T> any() {
        return new IngredientNumberBuilder(this, this::makeMust);
    }

    public IngredientNumberBuilder<T> only() {
        return new IngredientNumberBuilder(this, this::makeOnly);
    }

    public IngredientConditionsBuilder<T> require() {
        return new IngredientConditionsBuilder<T>(this.parent, this.al, this.al, this.dy);
    }

    public IngredientConditionsBuilder<T> not() {
        return new IngredientConditionsBuilder<T>(this.parent, this.dy, this.al, this.dy);
    }

    private void makeMust(CookIngredients sn) {
        this.li.add(new Must(sn));
    }

    private void makeOnly(CookIngredients sn) {
        this.li.add(new Only(sn));
    }

    public T then() {
        return this.parent;
    }
}

