/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.data.InvalidRecipeException;
import com.teammoeg.caupona.data.SerializeUtil;
import com.teammoeg.caupona.fluid.SoupFluid;
import com.teammoeg.caupona.item.StewItem;
import com.teammoeg.caupona.util.StewInfo;
import com.teammoeg.caupona.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class DoliumRecipe
extends IDataRecipe {
    public static List<DoliumRecipe> recipes;
    public static RegistryObject<RecipeType<Recipe<?>>> TYPE;
    public static RegistryObject<RecipeSerializer<?>> SERIALIZER;
    public List<Pair<Ingredient, Integer>> items;
    public Ingredient extra;
    public ResourceLocation base;
    public Fluid fluid = Fluids.f_76191_;
    public int amount = 250;
    public float density = 0.0f;
    public boolean keepInfo = false;
    public ItemStack output;

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TYPE.get();
    }

    public DoliumRecipe(ResourceLocation id, ResourceLocation base, Fluid fluid, int amount, float density, boolean keep, ItemStack out, List<Pair<Ingredient, Integer>> items) {
        this(id, base, fluid, amount, density, keep, out, items, null);
    }

    public DoliumRecipe(ResourceLocation id, ResourceLocation base, Fluid fluid, int amount, float density, boolean keep, ItemStack out, Collection<Pair<Ingredient, Integer>> items, Ingredient ext) {
        super(id);
        this.items = items != null ? new ArrayList<Pair<Ingredient, Integer>>(items) : new ArrayList<Pair<Ingredient, Integer>>();
        this.base = base;
        this.fluid = fluid;
        this.density = density;
        this.amount = amount;
        this.output = out;
        this.extra = ext;
        this.keepInfo = keep;
    }

    public DoliumRecipe(ResourceLocation id, JsonObject jo) {
        super(id);
        if (jo.has("items")) {
            this.items = SerializeUtil.parseJsonList(jo.get("items"), j -> Pair.of((Object)Ingredient.m_43917_((JsonElement)j.get("item")), (Object)(j.has("count") ? j.get("count").getAsInt() : 1)));
        }
        if (jo.has("base")) {
            this.base = new ResourceLocation(jo.get("base").getAsString());
        }
        if (jo.has("fluid")) {
            this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(jo.get("fluid").getAsString()));
        }
        if (jo.has("amount")) {
            this.amount = jo.get("amount").getAsInt();
        }
        if (jo.has("density")) {
            this.density = jo.get("density").getAsFloat();
        }
        if (jo.has("keepInfo")) {
            this.keepInfo = jo.get("keepInfo").getAsBoolean();
        }
        this.output = Ingredient.m_43917_((JsonElement)jo.get("output")).m_43908_()[0];
        if (jo.has("container")) {
            this.extra = Ingredient.m_43917_((JsonElement)jo.get("container"));
        }
        if (this.output == null) {
            throw new InvalidRecipeException("cannot load" + String.valueOf(id) + ": no output found!");
        }
    }

    public static DoliumRecipe testPot(FluidStack fluidStack) {
        return recipes.stream().filter(t -> t.test(fluidStack, ItemStack.f_41583_, new ItemStack[0])).findFirst().orElse(null);
    }

    public static boolean testInput(ItemStack stack) {
        return recipes.stream().anyMatch(t -> t.items.stream().anyMatch(i -> ((Ingredient)i.getFirst()).test(stack)));
    }

    public static boolean testContainer(ItemStack stack) {
        return recipes.stream().map(t -> t.extra).filter(Objects::nonNull).anyMatch(t -> t.test(stack));
    }

    public static DoliumRecipe testDolium(FluidStack f, ItemStackHandler inv) {
        ItemStack is0 = inv.getStackInSlot(0);
        ItemStack is1 = inv.getStackInSlot(1);
        ItemStack is2 = inv.getStackInSlot(2);
        ItemStack cont = inv.getStackInSlot(4);
        return recipes.stream().filter(t -> t.test(f, cont, is0, is1, is2)).findFirst().orElse(null);
    }

    public boolean test(FluidStack f, ItemStack container, ItemStack ... ss) {
        if (this.items.size() > 0) {
            if (ss.length < this.items.size()) {
                return false;
            }
            int notEmpty = 0;
            for (ItemStack is : ss) {
                if (is.m_41619_()) continue;
                ++notEmpty;
            }
            if (notEmpty < this.items.size()) {
                return false;
            }
        }
        if (this.extra != null && !this.extra.test(container)) {
            return false;
        }
        if (!(this.fluid.m_6212_(Fluids.f_76191_) && f.isEmpty() || f.getFluid().m_6212_(this.fluid))) {
            return false;
        }
        if (this.amount > 0 && f.getAmount() < this.amount) {
            return false;
        }
        if (this.density != 0.0f || this.base != null) {
            StewInfo info = SoupFluid.getInfo(f);
            if (this.base != null && !info.base.equals((Object)this.base)) {
                return false;
            }
            if (info.getDensity() < this.density) {
                return false;
            }
        }
        for (Pair<Ingredient, Integer> igd : this.items) {
            boolean flag = false;
            for (ItemStack is : ss) {
                if (!((Ingredient)igd.getFirst()).test(is) || is.m_41613_() < (Integer)igd.getSecond()) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            return false;
        }
        return true;
    }

    public ItemStack handle(FluidStack f) {
        int times = 1;
        if (this.amount > 0) {
            times = f.getAmount() / this.amount;
        }
        ItemStack out = this.output.m_41777_();
        out.m_41764_(out.m_41613_() * times);
        if (this.keepInfo) {
            StewInfo info = SoupFluid.getInfo(f);
            StewItem.setInfo(out, info);
        }
        f.shrink(times * this.amount);
        return out;
    }

    public ItemStack handleDolium(FluidStack f, ItemStackHandler inv) {
        ItemStack is;
        int i;
        int times = this.output.m_41741_();
        if (this.amount > 0) {
            times = Math.min(f.getAmount() / this.amount, times);
        }
        if (this.extra != null) {
            times = Math.min(times, inv.getStackInSlot(4).m_41613_());
        }
        block0: for (Pair<Ingredient, Integer> igd : this.items) {
            if ((Integer)igd.getSecond() == 0) continue;
            for (i = 0; i < 3; ++i) {
                is = inv.getStackInSlot(i);
                if (!((Ingredient)igd.getFirst()).test(is)) continue;
                times = Math.min(times, is.m_41613_() / (Integer)igd.getSecond());
                continue block0;
            }
        }
        if (this.extra != null) {
            inv.getStackInSlot(4).m_41774_(times);
        }
        block2: for (Pair<Ingredient, Integer> igd : this.items) {
            if ((Integer)igd.getSecond() == 0) continue;
            for (i = 0; i < 3; ++i) {
                is = inv.getStackInSlot(i);
                if (!((Ingredient)igd.getFirst()).test(is)) continue;
                is.m_41774_(times * (Integer)igd.getSecond());
                continue block2;
            }
        }
        ItemStack out = this.output.m_41777_();
        out.m_41764_(out.m_41613_() * times);
        if (this.keepInfo) {
            StewInfo info = SoupFluid.getInfo(f);
            StewItem.setInfo(out, info);
        }
        if (this.amount > 0) {
            f.shrink(times * this.amount);
        }
        return out;
    }

    public DoliumRecipe(ResourceLocation id, FriendlyByteBuf data) {
        super(id);
        this.items = SerializeUtil.readList(data, d -> Pair.of((Object)Ingredient.m_43940_((FriendlyByteBuf)d), (Object)d.m_130242_()));
        this.base = SerializeUtil.readOptional(data, FriendlyByteBuf::m_130281_).orElse(null);
        this.fluid = (Fluid)data.readRegistryIdUnsafe(ForgeRegistries.FLUIDS);
        this.amount = data.m_130242_();
        this.density = data.readFloat();
        this.keepInfo = data.readBoolean();
        this.output = data.m_130267_();
        this.extra = SerializeUtil.readOptional(data, Ingredient::m_43940_).orElse(null);
    }

    public void write(FriendlyByteBuf data) {
        SerializeUtil.writeList(data, this.items, (r, d) -> {
            ((Ingredient)r.getFirst()).m_43923_(data);
            data.m_130130_(((Integer)r.getSecond()).intValue());
        });
        SerializeUtil.writeOptional2(data, this.base, FriendlyByteBuf::m_130085_);
        data.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, (Object)this.fluid);
        data.m_130130_(this.amount);
        data.writeFloat(this.density);
        data.writeBoolean(this.keepInfo);
        data.m_130055_(this.output);
        SerializeUtil.writeOptional(data, this.extra, Ingredient::m_43923_);
    }

    @Override
    public void serializeRecipeData(JsonObject json) {
        json.add("items", (JsonElement)SerializeUtil.toJsonList(this.items, r -> {
            JsonObject jo = new JsonObject();
            jo.add("item", ((Ingredient)r.getFirst()).m_43942_());
            jo.addProperty("count", (Number)r.getSecond());
            return jo;
        }));
        if (this.base != null) {
            json.addProperty("base", this.base.toString());
        }
        if (!this.fluid.m_6212_(Fluids.f_76191_)) {
            json.addProperty("fluid", Utils.getRegistryName(this.fluid).toString());
        }
        json.addProperty("density", (Number)Float.valueOf(this.density));
        json.addProperty("amount", (Number)this.amount);
        json.addProperty("keepInfo", Boolean.valueOf(this.keepInfo));
        json.add("output", StrictNBTIngredient.of((ItemStack)this.output).m_43942_());
        if (this.extra != null) {
            json.add("container", this.extra.m_43942_());
        }
    }
}

