/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.items;

import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCover;
import com.dannyandson.tinyredstone.blocks.PanelTileRenderer;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class PanelItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public PanelItemRenderer(BlockEntityRenderDispatcher p_172550_, EntityModelSet p_172551_) {
        super(p_172550_, p_172551_);
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext p_239207_2_, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        CompoundTag blockEntityTag;
        TextureAtlasSprite sprite = RenderHelper.getSprite(PanelTileRenderer.TEXTURE);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110451_());
        Integer color = DyeColor.GRAY.m_284406_().f_283871_;
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("BlockEntityTag") && (blockEntityTag = stack.m_41783_().m_128469_("BlockEntityTag")).m_128441_("color")) {
            color = blockEntityTag.m_128451_("color");
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.125, 0.0);
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("BlockEntityTag")) {
            CompoundTag itemTag = stack.m_41783_().m_128469_("BlockEntityTag");
            if (itemTag.m_128441_("cover")) {
                String coverClass = stack.m_41783_().m_128469_("BlockEntityTag").m_128461_("cover");
                try {
                    IPanelCover cover = (IPanelCover)Class.forName(coverClass).getConstructor(new Class[0]).newInstance(new Object[0]);
                    cover.readNBT(stack.m_41783_().m_128469_("BlockEntityTag").m_128469_("coverData"));
                    matrixStack.m_85836_();
                    cover.render(matrixStack, buffer, combinedLight, combinedOverlay, color);
                    matrixStack.m_85849_();
                }
                catch (Exception exception) {
                    TinyRedstone.LOGGER.error("Exception attempting to construct IPanelCover class for item render: " + coverClass + ": " + exception.getMessage() + " " + exception.getStackTrace()[0].toString());
                }
            } else {
                boolean hasBase;
                boolean bl = hasBase = !itemTag.m_128441_("hasBase") || itemTag.m_128471_("hasBase");
                if (hasBase) {
                    this.renderBase(matrixStack, builder, sprite, combinedLight, color);
                }
                CompoundTag cellsNBT = itemTag.m_128469_("cells");
                Integer i = 0;
                while (i < (hasBase ? 448 : 512)) {
                    CompoundTag cellNBT;
                    if (cellsNBT.m_128441_(i.toString()) && (cellNBT = cellsNBT.m_128469_(i.toString())).m_128441_("data")) {
                        String className = cellNBT.m_128461_("class");
                        try {
                            IPanelCell cell = (IPanelCell)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                            cell.readNBT(cellNBT.m_128469_("data"));
                            Side cellDirection = Side.valueOf(cellNBT.m_128461_("facing"));
                            this.renderCell(matrixStack, i, cell, cellDirection, buffer, combinedLight, combinedOverlay);
                        }
                        catch (Exception exception) {
                            TinyRedstone.LOGGER.error("Exception attempting to construct IPanelCell class for item render: " + className + ": " + exception.getMessage() + " " + exception.getStackTrace()[0].toString());
                        }
                    }
                    Integer n = i;
                    i = i + 1;
                }
            }
        } else {
            this.renderBase(matrixStack, builder, sprite, combinedLight, color);
        }
        matrixStack.m_85849_();
    }

    private void renderBase(PoseStack matrixStack, VertexConsumer builder, TextureAtlasSprite sprite, int combinedLight, int color) {
        matrixStack.m_85836_();
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(270.0f));
        matrixStack.m_85837_(0.0, -1.0, 0.125);
        this.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, color);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStack.m_85837_(0.0, -0.125, 0.0);
        this.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
        this.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
        this.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
        this.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, -1.0f, 0.0f);
        this.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, color);
        matrixStack.m_85849_();
    }

    private void renderCell(PoseStack matrixStack, Integer index, IPanelCell panelCell, Side cellDirection, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        float scale = 0.125f;
        float t2X = 0.0f;
        float t2Y = -1.0f;
        float t2Z = 0.0f;
        float rotation1 = 270.0f;
        double cellSize = 0.125;
        int level = Math.round(index.floatValue() / 64.0f - 0.5f);
        int row = Math.round(index.floatValue() % 64.0f / 8.0f - 0.5f);
        int cell = index % 8;
        matrixStack.m_85836_();
        matrixStack.m_85837_(cellSize * (double)row, 0.125 + cellSize * (double)level, cellSize * (double)cell);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(rotation1));
        if (cellDirection == Side.LEFT) {
            matrixStack.m_85837_(0.0, -cellSize, 0.0);
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        } else if (cellDirection == Side.BACK) {
            matrixStack.m_85837_(cellSize, -cellSize, 0.0);
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        } else if (cellDirection == Side.RIGHT) {
            matrixStack.m_85837_(cellSize, 0.0, 0.0);
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(270.0f));
        }
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_252880_(t2X, t2Y, t2Z);
        panelCell.render(matrixStack, buffer, combinedLight, combinedOverlay, 1.0f);
        matrixStack.m_85849_();
    }

    private void drawRectangle(VertexConsumer builder, PoseStack matrixStack, float x1, float x2, float y1, float y2, TextureAtlasSprite sprite, int combinedLight, Integer color) {
        this.add(builder, matrixStack, x1, y1, 0.0f, sprite.m_118409_(), sprite.m_118411_(), combinedLight, color);
        this.add(builder, matrixStack, x2, y1, 0.0f, sprite.m_118410_(), sprite.m_118411_(), combinedLight, color);
        this.add(builder, matrixStack, x2, y2, 0.0f, sprite.m_118410_(), sprite.m_118412_(), combinedLight, color);
        this.add(builder, matrixStack, x1, y2, 0.0f, sprite.m_118409_(), sprite.m_118412_(), combinedLight, color);
    }

    private void add(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float u, float v, int combinedLightIn, Integer color) {
        renderer.m_252986_(stack.m_85850_().m_252922_(), x, y, z).m_6122_(RenderHelper.getRed(color), RenderHelper.getGreen(color), RenderHelper.getBlue(color), RenderHelper.getAlpha(color)).m_7421_(u, v).m_85969_(combinedLightIn).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }
}

