/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.registry;

import com.blakebr0.ironjetpacks.IronJetpacks;
import com.blakebr0.ironjetpacks.init.ModItems;
import com.blakebr0.ironjetpacks.lib.ModJetpacks;
import com.blakebr0.ironjetpacks.network.NetworkHandler;
import com.blakebr0.ironjetpacks.network.message.SyncJetpacksMessage;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;

public class JetpackRegistry {
    private static final JetpackRegistry INSTANCE = new JetpackRegistry();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<ResourceLocation, Jetpack> jetpacks = new LinkedHashMap<ResourceLocation, Jetpack>();
    private final ArrayList<Integer> tiers = new ArrayList();
    private int lowestTier = Integer.MAX_VALUE;
    private boolean isErrored = false;

    @SubscribeEvent
    public void onDatapackSync(OnDatapackSyncEvent event) {
        SyncJetpacksMessage message = new SyncJetpacksMessage(this.getJetpacks());
        ServerPlayer player = event.getPlayer();
        if (player != null) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
        } else {
            NetworkHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)message);
        }
    }

    public void register(Jetpack jetpack) {
        if (this.jetpacks.containsKey(jetpack.getId())) {
            this.isErrored = true;
            throw new RuntimeException(String.format("Tried to register multiple jetpacks with the same name: %s", jetpack.name));
        }
        this.jetpacks.put(jetpack.getId(), jetpack);
        if (jetpack.tier > -1 && !this.tiers.contains(jetpack.tier)) {
            this.tiers.add(jetpack.tier);
            this.tiers.sort(Integer::compareTo);
        }
        if (jetpack.tier > -1 && jetpack.tier < this.lowestTier) {
            this.lowestTier = jetpack.tier;
        }
    }

    public List<Jetpack> getJetpacks() {
        return new ArrayList<Jetpack>(this.jetpacks.values());
    }

    public List<Integer> getAllTiers() {
        return this.tiers;
    }

    public Integer getLowestTier() {
        return this.lowestTier;
    }

    public Jetpack getJetpackById(ResourceLocation id) {
        return this.jetpacks.getOrDefault(id, Jetpack.UNDEFINED);
    }

    public Item getCoilForTier(int tier) {
        float tiers = this.tiers.size();
        float index = this.tiers.indexOf(tier);
        if (index / tiers > 0.75f) {
            return (Item)ModItems.ULTIMATE_COIL.get();
        }
        if (index / tiers > 0.5f) {
            return (Item)ModItems.ELITE_COIL.get();
        }
        if (index / tiers > 0.25f) {
            return (Item)ModItems.ADVANCED_COIL.get();
        }
        return (Item)ModItems.BASIC_COIL.get();
    }

    public boolean isErrored() {
        return this.isErrored;
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.jetpacks.size());
        this.jetpacks.forEach((id, jetpack) -> jetpack.write(buffer));
    }

    public List<Jetpack> readFromBuffer(FriendlyByteBuf buffer) {
        ArrayList<Jetpack> jetpacks = new ArrayList<Jetpack>();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            Jetpack jetpack = Jetpack.read(buffer);
            jetpacks.add(jetpack);
        }
        return jetpacks;
    }

    public void loadJetpacks(SyncJetpacksMessage message) {
        this.jetpacks.clear();
        for (Jetpack jetpack : message.getJetpacks()) {
            this.jetpacks.put(jetpack.getId(), jetpack);
        }
        IronJetpacks.LOGGER.info("Loaded {} jetpacks from the server", (Object)this.jetpacks.size());
    }

    public void writeDefaultJetpackFiles() {
        File dir = FMLPaths.CONFIGDIR.get().resolve("ironjetpacks/jetpacks").toFile();
        if (!dir.exists() && dir.mkdirs()) {
            for (Jetpack jetpack : ModJetpacks.getDefaults()) {
                File file = new File(dir, jetpack.name + ".json");
                try (FileWriter writer = new FileWriter(file);){
                    GSON.toJson((JsonElement)jetpack.toJson(), (Appendable)writer);
                }
                catch (Exception e) {
                    IronJetpacks.LOGGER.error("An error occurred while generating jetpack jsons", (Throwable)e);
                }
            }
        }
    }

    public void loadJetpacks() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        File dir = FMLPaths.CONFIGDIR.get().resolve("ironjetpacks/jetpacks").toFile();
        this.writeDefaultJetpackFiles();
        this.jetpacks.clear();
        if (!dir.mkdirs() && dir.isDirectory()) {
            this.loadFiles(dir);
        }
        stopwatch.stop();
        IronJetpacks.LOGGER.info("Loaded {} jetpack type(s) in {} ms", (Object)this.jetpacks.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFiles(File dir) {
        File[] files = dir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"));
        if (files == null) {
            return;
        }
        ArrayList<Jetpack> jetpacks = new ArrayList<Jetpack>();
        for (File file : files) {
            JsonObject json;
            InputStreamReader reader;
            Jetpack jetpack;
            block15: {
                jetpack = null;
                reader = null;
                reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                JsonParser parser = new JsonParser();
                json = parser.parse((Reader)reader).getAsJsonObject();
                reader.close();
                if (!JetpackRegistry.handleMigrations(json)) break block15;
                try (FileWriter writer = new FileWriter(file);){
                    GSON.toJson((JsonElement)json, (Appendable)writer);
                }
                catch (Exception e) {
                    IronJetpacks.LOGGER.error("An error occurred while migrating jetpack json {}", (Object)file.getName(), (Object)e);
                    IOUtils.closeQuietly((Reader)reader);
                    continue;
                }
            }
            try {
                jetpack = Jetpack.fromJson(json);
            }
            catch (Exception e) {
                try {
                    IronJetpacks.LOGGER.error("An error occurred while reading jetpack json {}", (Object)file.getName(), (Object)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            IOUtils.closeQuietly((Reader)reader);
            if (jetpack == null || jetpack.disabled) continue;
            jetpacks.add(jetpack);
        }
        jetpacks.sort(Comparator.comparingInt(Jetpack::getTier));
        for (Jetpack jetpack : jetpacks) {
            this.register(jetpack);
        }
    }

    public static JetpackRegistry getInstance() {
        return INSTANCE;
    }

    private static boolean handleMigrations(JsonObject json) {
        boolean changed = false;
        if (!json.has("creative")) {
            json.addProperty("creative", Boolean.valueOf(false));
            changed = true;
        }
        if (!json.has("rarity")) {
            json.addProperty("rarity", (Number)0);
            changed = true;
        }
        if (!json.has("sprintSpeedMultiVertical")) {
            json.addProperty("sprintSpeedMultiVertical", (Number)1.0);
            changed = true;
        }
        if (!json.has("toughness")) {
            json.addProperty("toughness", (Number)Float.valueOf(0.0f));
            changed = true;
        }
        if (!json.has("knockbackResistance")) {
            json.addProperty("knockbackResistance", (Number)Float.valueOf(0.0f));
            changed = true;
        }
        if (!json.has("speedHoverAscend")) {
            if (json.has("speedHoverDescend")) {
                json.addProperty("speedHoverAscend", (Number)json.get("speedHoverDescend").getAsDouble());
            } else {
                json.addProperty("speedHoverAscend", (Number)0.25);
            }
            changed = true;
        }
        if (!json.has("curios")) {
            json.addProperty("curios", Boolean.valueOf(true));
            changed = true;
        }
        return changed;
    }
}

