/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.crafting.ingredient;

import com.blakebr0.ironjetpacks.init.ModItems;
import com.blakebr0.ironjetpacks.init.ModRecipeSerializers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class JetpackComponentIngredient
extends Ingredient {
    private final String jetpackId;
    private final ComponentType type;

    public JetpackComponentIngredient(String jetpackId, ComponentType type) {
        super(Stream.empty());
        this.jetpackId = jetpackId;
        this.type = type;
    }

    public JetpackComponentIngredient(String jetpackId, ComponentType type, Stream<Ingredient.ItemValue> itemList) {
        super(itemList);
        this.jetpackId = jetpackId;
        this.type = type;
    }

    public boolean test(ItemStack input) {
        if (input == null) {
            return false;
        }
        if (!super.test(input)) {
            return false;
        }
        return Arrays.stream(this.m_43908_()).anyMatch(s -> s.m_41773_() == input.m_41773_() && (!s.m_41782_() || s.areShareTagsEqual(input)));
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "ironjetpacks:jetpack_component");
        json.addProperty("component", this.type.name);
        json.addProperty("crop", this.jetpackId);
        return json;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return ModRecipeSerializers.JETPACK_COMPONENT_INGREDIENT;
    }

    public static enum ComponentType {
        CELL("cell"),
        THRUSTER("thruster"),
        CAPACITOR("capacitor"),
        JETPACK("jetpack");

        private static final Map<String, ComponentType> LOOKUP;
        public final String name;

        private ComponentType(String name) {
            this.name = name;
        }

        public static ComponentType fromName(String name) {
            return LOOKUP.get(name);
        }

        static {
            LOOKUP = new HashMap<String, ComponentType>();
            for (ComponentType value : ComponentType.values()) {
                LOOKUP.put(value.name, value);
            }
        }
    }

    public static class Serializer
    implements IIngredientSerializer<JetpackComponentIngredient> {
        public JetpackComponentIngredient parse(FriendlyByteBuf buffer) {
            String jetpackId = buffer.m_130277_();
            ComponentType type = ComponentType.fromName(buffer.m_130277_());
            Stream<Ingredient.ItemValue> itemList = Stream.generate(() -> ((FriendlyByteBuf)buffer).m_130267_()).limit(buffer.m_130242_()).map(Ingredient.ItemValue::new);
            return new JetpackComponentIngredient(jetpackId, type, itemList);
        }

        public JetpackComponentIngredient parse(JsonObject json) {
            String jetpackId = GsonHelper.m_13906_((JsonObject)json, (String)"jetpack");
            String typeName = GsonHelper.m_13906_((JsonObject)json, (String)"component");
            ComponentType type = ComponentType.fromName(typeName);
            ItemStack stack = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case ComponentType.CELL -> new ItemStack((ItemLike)ModItems.CELL.get());
                case ComponentType.THRUSTER -> new ItemStack((ItemLike)ModItems.THRUSTER.get());
                case ComponentType.CAPACITOR -> new ItemStack((ItemLike)ModItems.CAPACITOR.get());
                case ComponentType.JETPACK -> new ItemStack((ItemLike)ModItems.JETPACK.get());
            };
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("Id", jetpackId);
            stack.m_41751_(nbt);
            return new JetpackComponentIngredient(jetpackId, type, Stream.of(new Ingredient.ItemValue(stack)));
        }

        public void write(FriendlyByteBuf buffer, JetpackComponentIngredient ingredient) {
            buffer.m_130070_(ingredient.jetpackId);
            buffer.m_130070_(ingredient.type.name);
            ItemStack[] items = ingredient.m_43908_();
            buffer.m_130130_(items.length);
            for (ItemStack item : items) {
                buffer.m_130055_(item);
            }
        }
    }
}

