/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.common.event;

import cofh.ensorcellation.common.enchantment.SoulboundEnchantment;
import cofh.ensorcellation.init.registries.ModEnchantments;
import cofh.lib.common.enchantment.EnchantmentCoFH;
import cofh.lib.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ensorcellation")
public class SoulboundEvents {
    private SoulboundEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePlayerDropsEvent(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (Utils.isFakePlayer((Entity)player) || player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
                return;
            }
            ArrayList<ItemStack> soulbound = new ArrayList<ItemStack>();
            Iterator iter = event.getDrops().iterator();
            while (iter.hasNext()) {
                ItemStack stack = ((ItemEntity)iter.next()).m_32055_();
                if (Utils.getItemEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.SOULBOUND.get()), (ItemStack)stack) <= 0) continue;
                soulbound.add(stack);
                iter.remove();
            }
            CompoundTag playerData = player.getPersistentData();
            if (playerData.m_128441_("PlayerPersisted")) {
                playerData.m_128469_("PlayerPersisted").m_128473_("ensorcellation:soulbound");
            }
            if (!soulbound.isEmpty()) {
                ListTag list = new ListTag();
                for (ItemStack item : soulbound) {
                    if (item.m_41619_()) continue;
                    list.add((Object)item.m_41739_(new CompoundTag()));
                }
                if (!playerData.m_128441_("PlayerPersisted")) {
                    playerData.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
                }
                CompoundTag persistedTag = playerData.m_128469_("PlayerPersisted");
                persistedTag.m_128365_("ensorcellation:soulbound", (Tag)list);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePlayerCloneEvent(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player player = event.getEntity();
        if (Utils.isFakePlayer((Entity)player) || player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
            return;
        }
        EnchantmentCoFH soulbound = (EnchantmentCoFH)ModEnchantments.SOULBOUND.get();
        CompoundTag playerData = player.getPersistentData();
        if (playerData.m_128441_("PlayerPersisted")) {
            CompoundTag persistedTag = playerData.m_128469_("PlayerPersisted");
            ListTag list = persistedTag.m_128437_("ensorcellation:soulbound", 10);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
                int encSoulbound = Utils.getItemEnchantmentLevel((Enchantment)soulbound, (ItemStack)stack);
                if (encSoulbound <= 0) continue;
                if (SoulboundEnchantment.permanent) {
                    if (encSoulbound > 1) {
                        Utils.removeEnchantment((ItemStack)stack, (Enchantment)soulbound);
                        Utils.addEnchantment((ItemStack)stack, (Enchantment)soulbound, (int)1);
                    }
                } else if (player.f_19853_.f_46441_.m_188503_(1 + encSoulbound) == 0) {
                    Utils.removeEnchantment((ItemStack)stack, (Enchantment)soulbound);
                    if (encSoulbound > 1) {
                        Utils.addEnchantment((ItemStack)stack, (Enchantment)soulbound, (int)(encSoulbound - 1));
                    }
                }
                Utils.addToPlayerInventory((Player)player, (ItemStack)stack);
            }
            persistedTag.m_128473_("ensorcellation:soulbound");
        }
    }
}

