/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.fences;

import fr.samlegamer.addonslib.AddonsLib;
import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.item.BlockItemFuel;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class Fences {
    private static final BlockBehaviour.Properties wood = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_);
    private static final BlockBehaviour.Properties leave = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_);
    private static final BlockBehaviour.Properties stone = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50064_);
    public static final String modid = "mcwfences";

    public static void setRegistrationWood(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        Fences.setRegistrationWoodModLoaded(set, block, item, wood);
    }

    public static void setRegistrationHedges(List<String> leaves, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        Fences.setRegistrationHedgesModLoaded(leaves, block, item, leave);
    }

    public static void setRegistrationRock(List<String> rock, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        Fences.setRegistrationRockModLoaded(rock, block, item, stone);
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        for (String i : set) {
            try {
                RegistryObject<Block> curved_gate;
                RegistryObject<Block> pyramid_gate;
                RegistryObject<Block> highley_gate;
                RegistryObject<Block> wired_fence;
                RegistryObject<Block> horse_fence;
                RegistryObject<Block> stockade_fence;
                RegistryObject<Block> picket_fence;
                if (ModList.get().isLoaded(modid)) {
                    picket_fence = Fences.createBlock(i + "_picket_fence", () -> new FenceBlock(WOOD), block, item);
                    stockade_fence = Fences.createBlock(i + "_stockade_fence", () -> new FenceBlock(WOOD), block, item);
                    horse_fence = Fences.createBlock(i + "_horse_fence", () -> new FenceBlock(WOOD), block, item);
                    wired_fence = Fences.createBlock(i + "_wired_fence", () -> Registration.getBlocksFieldForFences("com.mcwfences.kikoz.objects.WiredFence", WOOD), block, item);
                    highley_gate = Fences.createBlock(i + "_highley_gate", () -> new FenceGateBlock(WOOD, SoundEvents.f_11872_, SoundEvents.f_11873_), block, item);
                    pyramid_gate = Fences.createBlock(i + "_pyramid_gate", () -> new FenceGateBlock(WOOD, SoundEvents.f_11872_, SoundEvents.f_11873_), block, item);
                    curved_gate = Fences.createBlock(i + "_curved_gate", () -> Registration.getBlocksFieldForFences("com.mcwfences.kikoz.objects.DoubleGate", WOOD), block, item);
                    continue;
                }
                picket_fence = Fences.createBlock(i + "_picket_fence", () -> new FenceBlock(WOOD), block, item);
                stockade_fence = Fences.createBlock(i + "_stockade_fence", () -> new FenceBlock(WOOD), block, item);
                horse_fence = Fences.createBlock(i + "_horse_fence", () -> new FenceBlock(WOOD), block, item);
                wired_fence = Fences.createBlock(i + "_wired_fence", () -> new FenceBlock(WOOD), block, item);
                highley_gate = Fences.createBlock(i + "_highley_gate", () -> new FenceGateBlock(WOOD, SoundEvents.f_11872_, SoundEvents.f_11873_), block, item);
                pyramid_gate = Fences.createBlock(i + "_pyramid_gate", () -> new FenceGateBlock(WOOD, SoundEvents.f_11872_, SoundEvents.f_11873_), block, item);
                curved_gate = Fences.createBlock(i + "_curved_gate", () -> new FenceBlock(WOOD), block, item);
            }
            catch (Exception e) {
                AddonsLib.LOGGER.error((Object)e);
            }
        }
    }

    public static void setRegistrationHedgesModLoaded(List<String> leaves, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties HEDGES = prop;
        for (String i : leaves) {
            RegistryObject<Block> hedge;
            if (ModList.get().isLoaded(modid)) {
                hedge = Fences.createBlock(i + "_hedge", () -> Registration.getBlocksFieldForFences("com.mcwfences.kikoz.objects.FenceHitbox", HEDGES), block, item);
                continue;
            }
            hedge = Fences.createBlock(i + "_hedge", () -> new FenceBlock(HEDGES), block, item);
        }
    }

    public static void setRegistrationRockModLoaded(List<String> rock, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        for (String i : rock) {
            RegistryObject<Block> grass_topped_wall;
            RegistryObject<Block> pillar_wall;
            RegistryObject<Block> railing_gate;
            RegistryObject<Block> railing_wall;
            RegistryObject<Block> modern_wall;
            if (ModList.get().isLoaded(modid)) {
                modern_wall = Fences.createBlockStone("modern_" + i + "_wall", () -> new FenceBlock(STONE), block, item);
                railing_wall = Fences.createBlockStone("railing_" + i + "_wall", () -> new FenceBlock(STONE), block, item);
                railing_gate = Fences.createBlockStone(i + "_railing_gate", () -> new FenceGateBlock(STONE, SoundEvents.f_11872_, SoundEvents.f_11873_), block, item);
                pillar_wall = Fences.createBlockStone(i + "_pillar_wall", () -> new FenceBlock(STONE), block, item);
                grass_topped_wall = Fences.createBlock(i + "_grass_topped_wall", () -> Registration.getBlocksFieldForFences("com.mcwfences.kikoz.objects.FenceHitbox", STONE), block, item);
                continue;
            }
            modern_wall = Fences.createBlockStone("modern_" + i + "_wall", () -> new FenceBlock(STONE), block, item);
            railing_wall = Fences.createBlockStone("railing_" + i + "_wall", () -> new FenceBlock(STONE), block, item);
            railing_gate = Fences.createBlockStone(i + "_railing_gate", () -> new FenceGateBlock(STONE, SoundEvents.f_11872_, SoundEvents.f_11873_), block, item);
            pillar_wall = Fences.createBlockStone(i + "_pillar_wall", () -> new FenceBlock(STONE), block, item);
            grass_topped_wall = Fences.createBlockStone(i + "_grass_topped_wall", () -> new FenceBlock(STONE), block, item);
        }
    }

    protected static RegistryObject<Block> createBlock(String name, Supplier<? extends Block> supplier, DeferredRegister<Block> BLOCKS_REGISTRY, DeferredRegister<Item> ITEMS_REGISTRY) {
        RegistryObject block = BLOCKS_REGISTRY.register(name, supplier);
        ITEMS_REGISTRY.register(name, () -> new BlockItemFuel((Block)block.get(), new Item.Properties()));
        return block;
    }

    protected static RegistryObject<Block> createBlockStone(String name, Supplier<? extends Block> supplier, DeferredRegister<Block> BLOCKS_REGISTRY, DeferredRegister<Item> ITEMS_REGISTRY) {
        RegistryObject block = BLOCKS_REGISTRY.register(name, supplier);
        ITEMS_REGISTRY.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    public static void addToTab(BuildCreativeModeTabContentsEvent event, String MODID, List<String> WOOD, CreativeModeTab tab) {
        Fences.addToTabModLoaded(event, MODID, WOOD, tab, "minecraft");
    }

    public static void addToTabModLoaded(BuildCreativeModeTabContentsEvent event, String MODID, List<String> WOOD, CreativeModeTab tab, String modLoaded) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid) && ModList.get().isLoaded(modLoaded)) {
            for (String i : WOOD) {
                Block picket_fence = Finder.findBlock(MODID, i + "_picket_fence");
                Block stockade_fence = Finder.findBlock(MODID, i + "_stockade_fence");
                Block horse_fence = Finder.findBlock(MODID, i + "_horse_fence");
                Block wired_fence = Finder.findBlock(MODID, i + "_wired_fence");
                Block highley_gate = Finder.findBlock(MODID, i + "_highley_gate");
                Block pyramid_gate = Finder.findBlock(MODID, i + "_pyramid_gate");
                Block curved_gate = Finder.findBlock(MODID, i + "_curved_gate");
                event.m_246326_((ItemLike)picket_fence);
                event.m_246326_((ItemLike)stockade_fence);
                event.m_246326_((ItemLike)horse_fence);
                event.m_246326_((ItemLike)wired_fence);
                event.m_246326_((ItemLike)highley_gate);
                event.m_246326_((ItemLike)pyramid_gate);
                event.m_246326_((ItemLike)curved_gate);
            }
        }
    }

    public static void addToTabHedge(BuildCreativeModeTabContentsEvent event, String MODID, List<String> LEAVES, CreativeModeTab tab) {
        Fences.addToTabHedgeModLoaded(event, MODID, LEAVES, tab, "minecraft");
    }

    public static void addToTabHedgeModLoaded(BuildCreativeModeTabContentsEvent event, String MODID, List<String> LEAVES, CreativeModeTab tab, String modLoaded) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid) && ModList.get().isLoaded(modLoaded)) {
            for (String i : LEAVES) {
                Block hedge = Finder.findBlock(MODID, i + "_hedge");
                event.m_246326_((ItemLike)hedge);
            }
        }
    }

    public static void addToTabStone(BuildCreativeModeTabContentsEvent event, String MODID, List<String> STONE, CreativeModeTab tab) {
        Fences.addToTabStoneModLoaded(event, MODID, STONE, tab, "minecraft");
    }

    public static void addToTabStoneModLoaded(BuildCreativeModeTabContentsEvent event, String MODID, List<String> STONE, CreativeModeTab tab, String modLoaded) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid) && ModList.get().isLoaded(modLoaded)) {
            for (String i : STONE) {
                Block modern_wall = Finder.findBlock(MODID, "modern_" + i + "_wall");
                Block railing_wall = Finder.findBlock(MODID, "railing_" + i + "_wall");
                Block railing_gate = Finder.findBlock(MODID, i + "_railing_gate");
                Block pillar_wall = Finder.findBlock(MODID, i + "_pillar_wall");
                Block grass_topped_wall = Finder.findBlock(MODID, i + "_grass_topped_wall");
                event.m_246326_((ItemLike)modern_wall);
                event.m_246326_((ItemLike)railing_wall);
                event.m_246326_((ItemLike)railing_gate);
                event.m_246326_((ItemLike)pillar_wall);
                event.m_246326_((ItemLike)grass_topped_wall);
            }
        }
    }
}

