/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.misc.CompressionService;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;

public class DecompressionPattern
implements IPatternDetails {
    static final String NBT_BASE = "base";
    static final String NBT_VARIANT = "variant";
    static final String NBT_FACTOR = "factor";
    private final AEItemKey definition;
    private final AEItemKey base;
    private final AEItemKey variant;
    private final byte factor;

    public DecompressionPattern(AEItemKey definition) {
        this.definition = definition;
        CompoundTag tag = Objects.requireNonNull(definition.getTag());
        this.base = AEItemKey.fromTag((CompoundTag)tag.m_128469_(NBT_BASE));
        this.variant = AEItemKey.fromTag((CompoundTag)tag.m_128469_(NBT_VARIANT));
        this.factor = tag.m_128445_(NBT_FACTOR);
    }

    public DecompressionPattern(AEItemKey base, CompressionService.Variant variant) {
        this.base = base;
        this.variant = variant.item();
        this.factor = variant.factor();
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(NBT_BASE, (Tag)this.base.toTag());
        tag.m_128365_(NBT_VARIANT, (Tag)this.variant.toTag());
        tag.m_128344_(NBT_FACTOR, this.factor);
        this.definition = AEItemKey.of(MEGAItems.DECOMPRESSION_PATTERN, (CompoundTag)tag);
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        return new IPatternDetails.IInput[]{new Input(this.variant)};
    }

    public GenericStack[] getOutputs() {
        return new GenericStack[]{new GenericStack((AEKey)this.base, (long)this.factor)};
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((DecompressionPattern)obj).definition.equals((Object)this.definition);
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    private record Input(AEItemKey input) implements IPatternDetails.IInput
    {
        public GenericStack[] getPossibleInputs() {
            return new GenericStack[]{new GenericStack((AEKey)this.input, 1L)};
        }

        public long getMultiplier() {
            return 1L;
        }

        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.getPossibleInputs()[0]);
        }

        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

