/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.utils;

import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public final class Registry<T> {
    private final HashBiMap<ResourceLocation, T> backingMap = HashBiMap.create();
    @Nullable
    private final T defaultValue;
    private Codec<T> codec;

    public Registry(@Nullable T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Registry() {
        this.defaultValue = null;
    }

    public T register(ResourceLocation key, T value) {
        Objects.requireNonNull(key, "Key cannot be null");
        Objects.requireNonNull(value, "Value cannot be null");
        if (this.backingMap.containsKey((Object)key)) {
            throw new IllegalStateException("Key already present: " + String.valueOf(key));
        }
        this.backingMap.put((Object)key, value);
        return value;
    }

    public T get(ResourceLocation key) {
        return (T)this.backingMap.getOrDefault((Object)key, this.defaultValue);
    }

    public ResourceLocation getKey(T value) {
        return (ResourceLocation)this.backingMap.inverse().get(value);
    }

    public Codec<T> codec() {
        return this.codec == null ? (this.codec = ResourceLocation.f_135803_.flatXmap(location -> Registry.failIfNull(this.get((ResourceLocation)location), () -> "Registry entry not present: %s".formatted(location)), object -> Registry.failIfNull(this.getKey(object), () -> "No key present for object: %s".formatted(object)))) : this.codec;
    }

    private static <R> DataResult<R> failIfNull(R object, Supplier<String> errorMessage) {
        return object != null ? DataResult.success(object) : DataResult.error(errorMessage);
    }
}

