/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.utils;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class DynamicTextureMap {
    private DynamicTexture mapTex;
    private ResourceLocation mapTexId;
    private final int resolution;
    private boolean released = true;

    public DynamicTextureMap(int resolution) {
        this.resolution = resolution;
    }

    public void init(TextureManager manager, String id) {
        this.released = false;
        this.mapTex = new DynamicTexture(this.resolution * 3, this.resolution * 2, false);
        this.mapTexId = manager.m_118490_(id, this.mapTex);
    }

    public void drawAll(Consumer<DrawContext> drawCallback) {
        if (this.released) {
            return;
        }
        try (DrawContext ctx = new DrawContext(this);){
            for (Direction dir : Direction.values()) {
                ctx.mapFace(dir);
                drawCallback.accept(ctx);
            }
        }
    }

    public void draw(Direction dir, Consumer<DrawContext> drawCallback) {
        if (this.released) {
            return;
        }
        try (DrawContext ctx = new DrawContext(this);){
            ctx.mapFace(dir);
            drawCallback.accept(ctx);
        }
    }

    public ResourceLocation location() {
        return this.mapTexId;
    }

    public float getU(float u, Direction dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> u / 3.0f;
            case Direction.NORTH, Direction.SOUTH -> u / 3.0f + 0.33333334f;
            case Direction.WEST, Direction.EAST -> u / 3.0f + 0.6666667f;
        };
    }

    public float getU0(Direction dir) {
        return this.getU(0.0f, dir);
    }

    public float getU1(Direction dir) {
        return this.getU(1.0f, dir);
    }

    public float getV(float v, Direction dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP, Direction.NORTH, Direction.EAST -> v / 2.0f;
            case Direction.DOWN, Direction.SOUTH, Direction.WEST -> v / 2.0f + 0.5f;
        };
    }

    public float getV0(Direction dir) {
        return this.getV(0.0f, dir);
    }

    public float getV1(Direction dir) {
        return this.getV(1.0f, dir);
    }

    public void release() {
        this.released = true;
        Minecraft.m_91087_().m_91097_().m_118513_(this.mapTexId);
    }

    public static class DrawContext
    implements AutoCloseable {
        private final DynamicTextureMap map;
        private final NativeImage pixels;
        private Direction face;
        private int offsetX;
        private int offsetY;
        private boolean shouldUpload = true;

        public DrawContext(DynamicTextureMap map) {
            this.map = map;
            this.offsetX = 0;
            this.offsetY = 0;
            this.face = Direction.UP;
            this.pixels = map.mapTex.m_117991_();
        }

        public void setPixelColor(int x, int y, int colorABGR) {
            this.pixels.m_84988_(x + this.offsetX, y + this.offsetY, colorABGR);
        }

        public void setPixelColorSafe(int x, int y, int abgr) {
            if (x >= this.map.resolution || x < 0 || y >= this.map.resolution || y < 0) {
                return;
            }
            this.setPixelColor(x, y, abgr);
        }

        public int getPixelColor(int x, int y) {
            return this.pixels.m_84985_(x, y);
        }

        public void blendPixel(int x, int y, int colorAGBR) {
            this.pixels.m_166411_(x + this.offsetX, y + this.offsetY, colorAGBR);
        }

        public void applyToPixels(IntUnaryOperator operator) {
            for (int y = this.offsetY; y < this.map.resolution + this.offsetY; ++y) {
                for (int x = this.offsetX; x < this.map.resolution + this.offsetX; ++x) {
                    this.pixels.m_84988_(x, y, operator.applyAsInt(this.pixels.m_84985_(x, y)));
                }
            }
        }

        private void mapFace(Direction dir) {
            this.face = dir;
            this.offsetX = switch (dir) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN, Direction.UP -> 0;
                case Direction.NORTH, Direction.SOUTH -> this.map.resolution;
                case Direction.WEST, Direction.EAST -> this.map.resolution * 2;
            };
            this.offsetY = switch (dir) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.UP, Direction.NORTH, Direction.EAST -> 0;
                case Direction.DOWN, Direction.SOUTH, Direction.WEST -> this.map.resolution;
            };
        }

        public DynamicTextureMap getMap() {
            return this.map;
        }

        public DynamicTexture getMapTex() {
            return this.map.mapTex;
        }

        public Direction face() {
            return this.face;
        }

        public void cancel() {
            this.shouldUpload = false;
        }

        @Override
        public void close() {
            if (this.shouldUpload) {
                this.map.mapTex.m_117985_();
            }
        }
    }
}

