/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.resources;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import dev.mayaqq.estrogen.Estrogen;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class EstrogenSplashLoader
extends SimpleJsonResourceReloadListener {
    public static final EstrogenSplashLoader INSTANCE = new EstrogenSplashLoader(new Gson(), "splashes");
    public List<Component> splashes = new ArrayList<Component>();

    public EstrogenSplashLoader(Gson gson, String directory) {
        super(gson, directory);
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        this.splashes.clear();
        object.forEach((key, value) -> {
            if (key.m_135827_().equals("estrogen") && key.m_135815_().equals("splashes")) {
                value.getAsJsonObject().getAsJsonArray("splashes").forEach(element -> {
                    if (element.isJsonObject()) {
                        try {
                            String formatted = EstrogenSplashLoader.parse(element.getAsJsonObject().toString());
                            this.splashes.add((Component)Component.Serializer.m_130714_((String)formatted));
                        }
                        catch (Exception e) {
                            Estrogen.LOGGER.warn("Failed to parse splash text", (Throwable)e);
                        }
                    } else {
                        this.splashes.add((Component)Component.m_237113_((String)EstrogenSplashLoader.parse(element.getAsString())));
                    }
                });
            }
        });
    }

    private static String parse(String input) {
        input = EstrogenSplashLoader.replaceVariable(input, "percent", new Random().nextInt(101) + "%");
        input = EstrogenSplashLoader.replaceVariable(input, "username", Minecraft.m_91087_().m_91094_().m_92546_());
        return input;
    }

    private static String replaceVariable(String input, String name, String value) {
        String variable = "%" + name + "%";
        return input.replaceAll("(^|[^\\\\])" + variable, "$1" + value).replaceAll("\\\\" + variable, variable);
    }
}

