/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.registry.recipes.objects;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;

public record EntityObject(com.teamresourceful.bytecodecs.utils.Either<EntityType<?>, TagKey<EntityType<?>>> entity) {
    static int cycleCounter = 0;
    static int cycleAmount = 0;
    static EntityType<?> currentEntity = null;

    public static EntityObject of(EntityType<?> entity) {
        return new EntityObject(com.teamresourceful.bytecodecs.utils.Either.ofLeft(entity));
    }

    public static EntityObject of(TagKey<EntityType<?>> entity) {
        return new EntityObject(com.teamresourceful.bytecodecs.utils.Either.ofRight(entity));
    }

    public static EntityObject fromJson(JsonElement jsonElement) {
        JsonObject object = jsonElement.getAsJsonObject();
        if (object.has("entity")) {
            JsonElement entity = object.get("entity");
            String entityName = entity.getAsString();
            return new EntityObject(com.teamresourceful.bytecodecs.utils.Either.ofLeft((Object)((EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(entityName)))));
        }
        if (object.has("tag")) {
            JsonElement tag = object.get("tag");
            String tagName = tag.getAsString();
            return new EntityObject(com.teamresourceful.bytecodecs.utils.Either.ofRight((Object)TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_256780_.m_123023_(), (ResourceLocation)new ResourceLocation(tagName))));
        }
        throw new IllegalArgumentException("Invalid entity object json");
    }

    public static JsonElement toJson(EntityObject entityObject) {
        JsonObject object = new JsonObject();
        if (entityObject.entity.isLeft()) {
            object.addProperty("entity", BuiltInRegistries.f_256780_.m_7981_((Object)((EntityType)entityObject.entity.left().get())).toString());
            return object;
        }
        object.addProperty("tag", ((TagKey)entityObject.entity.right().get()).f_203868_().toString());
        return object;
    }

    public static EntityObject fromNetwork(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            return new EntityObject(com.teamresourceful.bytecodecs.utils.Either.ofLeft((Object)((EntityType)BuiltInRegistries.f_256780_.m_7745_(buf.m_130281_()))));
        }
        return new EntityObject(com.teamresourceful.bytecodecs.utils.Either.ofRight((Object)TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_256780_.m_123023_(), (ResourceLocation)buf.m_130281_())));
    }

    public void toNetwork(FriendlyByteBuf buf) {
        if (this.entity.isLeft()) {
            buf.writeBoolean(true);
            buf.m_130085_(BuiltInRegistries.f_256780_.m_7981_((Object)((EntityType)this.entity.left().get())));
        } else {
            buf.writeBoolean(false);
            buf.m_130085_(((TagKey)this.entity.right().get()).f_203868_());
        }
    }

    public boolean matches(EntityType<?> entity) {
        if (this.entity.isLeft()) {
            return ((EntityType)this.entity.left().get()).equals(entity);
        }
        return entity.m_204039_((TagKey)this.entity.right().get());
    }

    public EntityType<?> getCycling() {
        if (this.entity.isLeft()) {
            return (EntityType)this.entity.left().get();
        }
        if (cycleCounter == 0) {
            ArrayList<EntityType<?>> entityTypes = this.getEntityTypes();
            currentEntity = entityTypes.get(0);
        }
        if (cycleCounter >= 100) {
            cycleCounter = 1;
            currentEntity = this.getEntityTypes().get(cycleAmount);
        }
        if (++cycleAmount >= this.getEntityTypes().size()) {
            cycleAmount = 0;
        }
        ++cycleCounter;
        return currentEntity;
    }

    public ItemStack[] spawnEggs() {
        ArrayList<EntityType<?>> entityTypes = this.getEntityTypes();
        ItemStack[] spawnEggs = new ItemStack[entityTypes.size()];
        for (int i = 0; i < entityTypes.size(); ++i) {
            spawnEggs[i] = SpawnEggItem.m_43213_(entityTypes.get(i)).m_7968_();
        }
        return spawnEggs;
    }

    private ArrayList<EntityType<?>> getEntityTypes() {
        ArrayList entityTypes = new ArrayList();
        BuiltInRegistries.f_256780_.m_206058_((TagKey)this.entity.right().get()).forEach(entityTypeHolder -> {
            Either either = entityTypeHolder.m_203439_();
            if (either.left().isPresent()) {
                entityTypes.add((EntityType)BuiltInRegistries.f_256780_.m_6246_((ResourceKey)either.left().get()));
            } else {
                entityTypes.add((EntityType)either.right().get());
            }
        });
        return entityTypes;
    }
}

