/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.registry.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.recipes.IngredientCodec;
import com.teamresourceful.resourcefullib.common.codecs.recipes.ItemStackCodec;
import com.teamresourceful.resourcefullib.common.recipe.CodecRecipe;
import dev.mayaqq.estrogen.registry.EstrogenRecipes;
import dev.mayaqq.estrogen.registry.recipes.codecs.EntityObjectCodec;
import dev.mayaqq.estrogen.registry.recipes.inventory.EntityInteractionInventory;
import dev.mayaqq.estrogen.registry.recipes.objects.EntityObject;
import dev.mayaqq.estrogen.utils.recipe.RecipeTypeInfo;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record EntityInteractionRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result, EntityObject entity, ResourceLocation sound, Boolean cantBeBaby) implements CodecRecipe<EntityInteractionInventory>
{
    public static RecipeTypeInfo getRecipeTypeInfo() {
        return new RecipeTypeInfo(new ResourceLocation("estrogen", "entity_interaction"), (RecipeType)EstrogenRecipes.ENTITY_INTERACTION.get(), (RecipeSerializer)EstrogenRecipes.ENTITY_INTERACTION_SERIALIZER.get());
    }

    public static Codec<EntityInteractionRecipe> codec(ResourceLocation id) {
        return RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)id), (App)IngredientCodec.CODEC.fieldOf("ingredient").forGetter(EntityInteractionRecipe::ingredient), (App)ItemStackCodec.CODEC.fieldOf("result").forGetter(EntityInteractionRecipe::result), (App)EntityObjectCodec.CODEC.fieldOf("entity").forGetter(EntityInteractionRecipe::entity), (App)ResourceLocation.f_135803_.fieldOf("sound").forGetter(EntityInteractionRecipe::sound), (App)Codec.BOOL.fieldOf("cant_be_baby").forGetter(EntityInteractionRecipe::cantBeBaby)).apply((Applicative)instance, EntityInteractionRecipe::new));
    }

    public static Codec<EntityInteractionRecipe> netCodec(ResourceLocation id) {
        return RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)id), (App)IngredientCodec.NETWORK_CODEC.fieldOf("ingredient").forGetter(EntityInteractionRecipe::ingredient), (App)ItemStackCodec.NETWORK_CODEC.fieldOf("result").forGetter(EntityInteractionRecipe::result), (App)EntityObjectCodec.NETWORK_CODEC.fieldOf("entity").forGetter(EntityInteractionRecipe::entity), (App)ResourceLocation.f_135803_.fieldOf("sound").forGetter(EntityInteractionRecipe::sound), (App)Codec.BOOL.fieldOf("cant_be_baby").forGetter(EntityInteractionRecipe::cantBeBaby)).apply((Applicative)instance, EntityInteractionRecipe::new));
    }

    public boolean matches(EntityInteractionInventory container, Level level) {
        if (!this.ingredient.test(container.stack())) {
            return false;
        }
        if (!this.entity.matches(container.entity())) {
            return false;
        }
        Entity entity = container.entity().m_20615_(level);
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            return !animal.m_6162_() || this.cantBeBaby == false;
        }
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EstrogenRecipes.ENTITY_INTERACTION_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)EstrogenRecipes.ENTITY_INTERACTION.get();
    }

    public ItemStack assemble(@NotNull EntityInteractionInventory container, @NotNull RegistryAccess access) {
        return this.result.m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }
}

