/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.registry.recipes;

import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import dev.mayaqq.estrogen.config.EstrogenConfig;
import dev.mayaqq.estrogen.platform.IngredientUtils;
import dev.mayaqq.estrogen.registry.EstrogenRecipes;
import dev.mayaqq.estrogen.registry.blockEntities.CentrifugeBlockEntity;
import dev.mayaqq.estrogen.utils.recipe.RecipeTypeInfo;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CentrifugingRecipe
extends ProcessingRecipe<Inventory> {
    CentrifugeBlockEntity blockEntity;

    public CentrifugingRecipe(IRecipeTypeInfo typeInfo, ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(typeInfo, params);
    }

    public CentrifugingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        this(CentrifugingRecipe.getRecipeTypeInfo(), params);
    }

    public void setBlockEntity(CentrifugeBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public boolean matches(@NotNull Inventory inventory, @NotNull Level level) {
        double speedRequired;
        FluidContainer fluidContainerUp = FluidContainer.of((Level)level, (BlockPos)this.blockEntity.m_58899_().m_7494_(), (Direction)Direction.DOWN);
        FluidContainer fluidContainerDown = FluidContainer.of((Level)level, (BlockPos)this.blockEntity.m_58899_().m_7495_(), (Direction)Direction.UP);
        if (fluidContainerUp == null || fluidContainerDown == null) {
            return false;
        }
        FluidHolder fluidUp = fluidContainerUp.getFirstFluid();
        FluidHolder fluidDown = fluidContainerDown.getFirstFluid();
        if (fluidUp == null || fluidDown == null) {
            return false;
        }
        float speed = this.blockEntity.getSpeed();
        if (!((double)speed >= (speedRequired = ((Double)EstrogenConfig.server().centrifugeSpeedRequired.get()).doubleValue())) && !((double)speed <= -speedRequired)) {
            return false;
        }
        FluidHolder input = IngredientUtils.getFluidIngredients(this).get(0);
        FluidHolder output = IngredientUtils.getFluidResults(this).get(0);
        long amountOut = output.getFluidAmount();
        AtomicBoolean matches = new AtomicBoolean(false);
        fluidContainerDown.getFluids().forEach(fluidBottom -> {
            if (fluidBottom.matches(input) && fluidBottom.getFluidAmount() >= input.getFluidAmount() && fluidContainerUp.insertFluid(output, true) >= amountOut) {
                fluidContainerUp.getFluids().forEach(fluidTop -> {
                    if (fluidTop.matches(output) || fluidTop.isEmpty()) {
                        fluidContainerDown.extractFluid(input, false);
                        fluidContainerUp.insertFluid(output, false);
                        matches.set(true);
                    }
                });
            }
        });
        return matches.get();
    }

    public ItemStack assemble(Inventory container, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess);
    }

    public boolean m_8004_(int i, int j) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.getRollableResults().isEmpty() ? ItemStack.f_41583_ : ((ProcessingOutput)this.getRollableResults().get(0)).getStack();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.getTypeInfo().getSerializer();
    }

    public RecipeType<?> m_6671_() {
        return this.getTypeInfo().getType();
    }

    protected int getMaxInputCount() {
        return 0;
    }

    protected int getMaxOutputCount() {
        return 0;
    }

    protected int getMaxFluidInputCount() {
        return 1;
    }

    protected int getMaxFluidOutputCount() {
        return 1;
    }

    public static RecipeTypeInfo getRecipeTypeInfo() {
        return new RecipeTypeInfo(new ResourceLocation("estrogen", "centrifuging"), (RecipeType)EstrogenRecipes.CENTRIFUGING.get(), (RecipeSerializer)EstrogenRecipes.CENTRIFUGING_SERIALIZER.get());
    }
}

