/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.registry.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.color.Color;
import dev.mayaqq.estrogen.registry.EstrogenParticles;
import dev.mayaqq.estrogen.utils.EstrogenCodecs;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.FastColor;

public record DashTrailParticleOptions(UUID playerUUID, float r, float g, float b) implements ParticleOptions
{
    public static final Codec<DashTrailParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(UUID::fromString, UUID::toString).fieldOf("uuid").forGetter(DashTrailParticleOptions::playerUUID), (App)EstrogenCodecs.NORMALIZED_FLOAT.fieldOf("red").forGetter(DashTrailParticleOptions::r), (App)EstrogenCodecs.NORMALIZED_FLOAT.fieldOf("green").forGetter(DashTrailParticleOptions::g), (App)EstrogenCodecs.NORMALIZED_FLOAT.fieldOf("blue").forGetter(DashTrailParticleOptions::b)).apply((Applicative)instance, DashTrailParticleOptions::new));
    public static final ParticleOptions.Deserializer<DashTrailParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<DashTrailParticleOptions>(){

        public DashTrailParticleOptions fromCommand(ParticleType<DashTrailParticleOptions> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            UUID player = UUID.fromString(reader.readString());
            reader.expect(' ');
            Color color = Color.parse((String)reader.readString());
            return new DashTrailParticleOptions(player, color.getFloatRed(), color.getFloatGreen(), color.getFloatBlue());
        }

        public DashTrailParticleOptions fromNetwork(ParticleType<DashTrailParticleOptions> particleType, FriendlyByteBuf buffer) {
            int color = buffer.readInt();
            return new DashTrailParticleOptions(buffer.m_130259_(), (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f, (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f, (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f);
        }
    };

    public ParticleType<?> m_6012_() {
        return (ParticleType)EstrogenParticles.DASH_PLAYER.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeInt(FastColor.ARGB32.m_13660_((int)0, (int)((int)(this.r * 255.0f)), (int)((int)(this.g * 255.0f)), (int)((int)(this.b * 255.0f))));
        buffer.m_130077_(this.playerUUID);
    }

    public String m_5942_() {
        return "DashPlayerParticleOptions";
    }
}

