/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.registry.items;

import com.google.common.collect.Multimap;
import com.teamresourceful.resourcefullib.common.network.Packet;
import dev.mayaqq.estrogen.networking.EstrogenNetworkManager;
import dev.mayaqq.estrogen.networking.messages.s2c.ThighHighStylesPacket;
import dev.mayaqq.estrogen.registry.EstrogenAttributes;
import earth.terrarium.baubly.common.Bauble;
import earth.terrarium.baubly.common.SlotInfo;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ThighHighsItem
extends Item
implements Bauble {
    private final int primaryColorDefault;
    private final int secondaryColorDefault;
    private List<ResourceLocation> styles;
    public static final String TAG_PRIMARY = "primaryColor";
    public static final String TAG_SECONDARY = "secondaryColor";
    public static final String TAG_STYLE = "specialStyle";
    public static final CauldronInteraction CAULDRON_INTERACTION = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
        Item item = itemStack.m_41720_();
        if (!(item instanceof ThighHighsItem)) {
            return InteractionResult.PASS;
        }
        ThighHighsItem thighHighsItem = (ThighHighsItem)item;
        if (!thighHighsItem.hasCustomColor(itemStack)) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            thighHighsItem.clearColor(itemStack);
            player.m_36220_(Stats.f_12945_);
            LayeredCauldronBlock.m_153559_((BlockState)blockState, (Level)level, (BlockPos)blockPos);
        }
        level.m_245747_(blockPos, SoundEvents.f_11917_, SoundSource.BLOCKS, 0.5f, 1.8f, true);
        if (level.f_46443_) {
            float fillHeight = (float)((Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_)).intValue() / 3.0f;
            for (int i = 0; i < 8; ++i) {
                double xOff = level.f_46441_.m_188583_() / 5.0 + 0.5;
                double zOff = level.f_46441_.m_188583_() / 5.0 + 0.5;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123772_, (double)blockPos.m_123341_() + xOff, (double)blockPos.m_123342_() + (double)fillHeight * 0.8, (double)blockPos.m_123343_() + zOff, 0.0, 0.05, 0.0);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    };

    public ThighHighsItem(Item.Properties properties, int primaryColor, int secondaryColor) {
        super(properties);
        this.primaryColorDefault = primaryColor;
        this.secondaryColorDefault = secondaryColor;
    }

    public static int getItemColor(ItemStack stack, int tintIndex) {
        ThighHighsItem thighHighsItem = (ThighHighsItem)stack.m_41720_();
        if (thighHighsItem.getStyle(stack).isPresent()) {
            return -1;
        }
        return thighHighsItem.getColor(stack, tintIndex);
    }

    public void loadStyles(List<ResourceLocation> newStyles) {
        this.styles = newStyles;
    }

    public void syncStyles(ServerPlayer player) {
        EstrogenNetworkManager.CHANNEL.sendToPlayer((Packet)new ThighHighStylesPacket(this.styles), player);
    }

    public int getDefaultColor(int tintIndex) {
        return tintIndex == 0 ? this.primaryColorDefault : this.secondaryColorDefault;
    }

    public boolean hasCustomColor(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41783_();
        return compoundTag != null && compoundTag.m_128441_(TAG_PRIMARY) && compoundTag.m_128441_(TAG_SECONDARY);
    }

    public int getColor(ItemStack stack, int tintIndex) {
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag != null) {
            if (tintIndex == 0 && compoundTag.m_128441_(TAG_PRIMARY)) {
                return compoundTag.m_128451_(TAG_PRIMARY);
            }
            if (tintIndex == 1 && compoundTag.m_128441_(TAG_SECONDARY)) {
                return compoundTag.m_128451_(TAG_SECONDARY);
            }
        }
        return this.getDefaultColor(tintIndex);
    }

    public void clearColor(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag != null) {
            compoundTag.m_128473_(TAG_PRIMARY);
            compoundTag.m_128473_(TAG_SECONDARY);
        }
    }

    public void setColor(ItemStack stack, int primaryColor, int secondaryColor) {
        stack.m_41784_().m_128405_(TAG_PRIMARY, primaryColor);
        stack.m_41784_().m_128405_(TAG_SECONDARY, secondaryColor);
    }

    public void setStyle(ItemStack stack, ResourceLocation style) {
        stack.m_41784_().m_128359_(TAG_STYLE, style.toString());
    }

    public void setRandomStyle(ItemStack stack, RandomSource randomSource) {
        this.setStyle(stack, this.styles.get(randomSource.m_188503_(this.styles.size())));
    }

    public Stream<ItemStack> streamStyleItems() {
        if (this.styles == null || this.styles.isEmpty()) {
            return Stream.empty();
        }
        return this.styles.stream().map(s -> {
            ItemStack stack = this.m_7968_();
            this.setStyle(stack, (ResourceLocation)s);
            return stack;
        });
    }

    public Optional<ResourceLocation> getStyle(ItemStack stack) {
        ResourceLocation style;
        if (this.styles == null) {
            return Optional.empty();
        }
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(TAG_STYLE) && this.styles.contains(style = new ResourceLocation(tag.m_128461_(TAG_STYLE)))) {
            return Optional.of(style);
        }
        return Optional.empty();
    }

    public void clearStyle(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_(TAG_STYLE);
        }
    }

    public Multimap<Attribute, AttributeModifier> getModifiers(Multimap<Attribute, AttributeModifier> defaultModifiers, ItemStack stack, SlotInfo slot, UUID uuid) {
        defaultModifiers.put((Object)((Attribute)EstrogenAttributes.FALL_DAMAGE_RESISTANCE.get()), (Object)new AttributeModifier(uuid, "ThighHighsFallDamageResistance", 100.0, AttributeModifier.Operation.ADDITION));
        return defaultModifiers;
    }
}

