/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.registry.items;

import com.simibubi.create.AllEnchantments;
import dev.mayaqq.estrogen.config.EstrogenConfig;
import dev.mayaqq.estrogen.registry.EstrogenEffects;
import dev.mayaqq.estrogen.registry.EstrogenFluids;
import dev.mayaqq.estrogen.utils.EstrogenColors;
import earth.terrarium.baubly.common.Bauble;
import earth.terrarium.baubly.common.SlotInfo;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidItem;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EstrogenPatchesItem
extends Item
implements Bauble,
BotariumFluidItem<WrappedItemFluidContainer> {
    private static final int TRIGGER_EVERY_X_TICKS = 300;
    private static final int EFFECT_DURATION = 520;

    public EstrogenPatchesItem(Item.Properties properties) {
        super(properties);
    }

    public void tick(ItemStack stack, SlotInfo slot) {
        LivingEntity livingEntity;
        WrappedItemFluidContainer itemFluidManager = this.getFluidContainer(stack);
        Level level = slot.wearer().m_9236_();
        if (!level.f_46443_ && (livingEntity = slot.wearer()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (((FluidHolder)itemFluidManager.getFluids().get(0)).getFluidAmount() > 0L) {
                if (level.m_46467_() % 300L == 0L) {
                    this.addEffect(player, level);
                }
                if (((Boolean)EstrogenConfig.server().patchDrain.get()).booleanValue() && level.m_46467_() % (long)((Integer)EstrogenConfig.server().patchDrainAmount.get()).intValue() == 0L && !player.m_7500_()) {
                    itemFluidManager.extractFromSlot(0, FluidHolder.of((Fluid)((Fluid)EstrogenFluids.LIQUID_ESTROGEN.get()), (long)(FluidConstants.getBucketAmount() / 1000L)), false);
                    itemFluidManager.serialize(stack.m_41784_());
                }
            }
        }
    }

    public void addEffect(Player player, Level level) {
        player.m_7292_(new MobEffectInstance((MobEffect)EstrogenEffects.ESTROGEN_EFFECT.get(), 520, (Integer)EstrogenConfig.server().patchGirlPowerAmount.get() - 1, false, false, false));
    }

    public long getMaxCapacity(ItemStack stack) {
        return FluidConstants.getBucketAmount() + FluidConstants.getBucketAmount() / 2L * (long)EnchantmentHelper.m_44831_((ItemStack)stack).getOrDefault(AllEnchantments.CAPACITY.get(), 0).intValue();
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        ItemStackHolder holder = new ItemStackHolder(stack);
        ItemFluidContainer itemFluidManager = FluidContainer.of((ItemStackHolder)holder);
        if (itemFluidManager != null) {
            long amount = FluidConstants.toMillibuckets((long)((FluidHolder)itemFluidManager.getFluids().get(0)).getFluidAmount());
            long amountCapacity = FluidConstants.toMillibuckets((long)itemFluidManager.getTankCapacity(0));
            String fluidString = Component.m_237115_((String)"fluid_type.estrogen.liquid_estrogen").getString();
            tooltipComponents.add((Component)Component.m_237113_((String)" "));
            tooltipComponents.add((Component)Component.m_237113_((String)String.format("%s: %smb / %smb", fluidString, amount, amountCapacity)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
            tooltipComponents.add((Component)Component.m_237113_((String)" "));
        }
    }

    public void onEquip(ItemStack stack, SlotInfo slot) {
        LivingEntity livingEntity;
        Level level = slot.wearer().m_9236_();
        WrappedItemFluidContainer itemFluidManager = this.getFluidContainer(stack);
        if (!level.f_46443_ && (livingEntity = slot.wearer()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (((FluidHolder)itemFluidManager.getFluids().get(0)).getFluidAmount() > 0L) {
                this.addEffect(player, level);
            }
        }
    }

    public ItemStack getFullStack() {
        ItemStack stack = this.m_7968_();
        WrappedItemFluidContainer itemFluidManager = this.getFluidContainer(stack);
        itemFluidManager.insertFluid(FluidHolder.of((Fluid)((Fluid)EstrogenFluids.LIQUID_ESTROGEN.get()), (long)FluidConstants.getBucketAmount()), false);
        itemFluidManager.serialize(stack.m_41784_());
        return stack;
    }

    public long getAmount(ItemStack stack) {
        ItemStackHolder holder = new ItemStackHolder(stack);
        ItemFluidContainer itemFluidManager = FluidContainer.of((ItemStackHolder)holder);
        return ((FluidHolder)itemFluidManager.getFluids().get(0)).getFluidAmount();
    }

    public WrappedItemFluidContainer getFluidContainer(ItemStack stack) {
        return new WrappedItemFluidContainer(stack, (FluidContainer)new SimpleFluidContainer(this.getMaxCapacity(stack), 1, (amount, fluid) -> fluid.is((Fluid)EstrogenFluids.LIQUID_ESTROGEN.get())));
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return this.getAmount(stack) != this.getMaxCapacity(stack);
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return (int)((double)this.getAmount(stack) / (double)this.getMaxCapacity(stack) * 13.0);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return EstrogenColors.ESTROGEN_PATCHES_BAR.value;
    }
}

