/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.registry.entities;

import dev.mayaqq.estrogen.platform.CommonPlatform;
import dev.mayaqq.estrogen.registry.EstrogenEntities;
import dev.mayaqq.estrogen.registry.EstrogenItems;
import dev.mayaqq.estrogen.registry.EstrogenParticles;
import dev.mayaqq.estrogen.registry.EstrogenSounds;
import dev.mayaqq.estrogen.registry.EstrogenTags;
import dev.mayaqq.estrogen.registry.entities.goals.TemptByLightBlockGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class MothEntity
extends Animal
implements FlyingAnimal,
Shearable {
    public static final int TICKS_PER_FLAP = 2;
    private static final EntityDataAccessor<Boolean> DATA_FUZZY = SynchedEntityData.m_135353_(MothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> ANIMATION_STATES = SynchedEntityData.m_135353_(MothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public final AnimationState flyingAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState fuzzUpFlyingAnimationState = new AnimationState();
    public final AnimationState fuzzUpIdleAnimationState = new AnimationState();
    public final AnimationState landingAnimationState = new AnimationState();
    public final AnimationState takingOffAnimationState = new AnimationState();
    public int ticksToFuzzUp = 0;
    private boolean fuzzingUp = false;
    private int fuzzupCooldown = 0;

    public MothEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.f_19804_.m_135372_(ANIMATION_STATES, (Object)1);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 48.0);
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Mob.m_217057_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && MothEntity.getDayTime(level) >= 1300 && MothEntity.getDayTime(level) <= 23999 && level.m_46941_() != 4;
    }

    private static int getDayTime(LevelAccessor level) {
        return (int)(level.m_8044_() % 24000L);
    }

    public void m_8119_() {
        int i;
        --this.fuzzupCooldown;
        if (this.fuzzupCooldown < 0) {
            this.fuzzupCooldown = 0;
        }
        if (this.fuzzupCooldown == 0) {
            this.fuzzingUp = false;
        }
        super.m_8119_();
        if (this.isFuzzy() && this.f_19796_.m_188501_() < 0.05f) {
            for (i = 0; i < this.f_19796_.m_188503_(2) + 1; ++i) {
                this.spawnFuzzyParticle(this.m_9236_(), this.m_20185_() - (double)0.3f, this.m_20185_() + (double)0.3f, this.m_20189_() - (double)0.3f, this.m_20189_() + (double)0.3f, this.m_20227_(0.5), this.getParticleType());
            }
        }
        if (!(this.m_9236_().f_46443_ || this.isFuzzy() || this.m_6162_() || this.m_9236_().m_46467_() % (long)this.getTicksToFuzzUp() != 0L)) {
            this.setFuzzy();
            for (i = 0; i <= 6; ++i) {
                this.spawnFuzzyParticle(this.m_9236_(), this.m_20185_() - (double)0.3f, this.m_20185_() + (double)0.3f, this.m_20189_() - (double)0.3f, this.m_20189_() + (double)0.3f, this.m_20227_(0.5), this.getParticleType());
            }
            this.m_216990_((SoundEvent)EstrogenSounds.MOTH_FUZZ_UP.get());
            this.fuzzingUp();
        }
    }

    private void fuzzingUp() {
        this.fuzzupCooldown = 48;
        this.fuzzingUp = true;
    }

    private boolean isFuzzingUp() {
        return this.fuzzingUp;
    }

    public void m_8107_() {
        boolean isMoving;
        super.m_8107_();
        boolean bl = isMoving = this.m_20185_() - this.f_19854_ != 0.0 || this.m_20189_() - this.f_19856_ != 0.0;
        if (this.m_29443_()) {
            if (this.isFuzzingUp()) {
                this.setState(State.FUZZUP_FLYING);
            }
            this.setState(State.FLYING);
        } else {
            if (this.isFuzzingUp()) {
                this.setState(State.FUZZUP_FLYING);
            }
            if (this.getState() == State.FLYING) {
                this.setState(State.LANDING);
            } else {
                this.setState(isMoving ? State.TAKING_OFF : State.IDLE);
            }
        }
    }

    private ParticleOptions getParticleType() {
        return (ParticleOptions)EstrogenParticles.MOTH_FUZZ.get();
    }

    private void spawnFuzzyParticle(Level level, double startX, double endX, double startZ, double endZ, double posY, ParticleOptions particleOption) {
        level.m_7106_(particleOption, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)startX, (double)endX), posY, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)startZ, (double)endZ), 0.0, 0.0, 0.0);
    }

    public State getState() {
        return State.values()[(Byte)this.f_19804_.m_135370_(ANIMATION_STATES)];
    }

    private void setState(State state) {
        this.f_19804_.m_135381_(ANIMATION_STATES, (Object)((byte)state.ordinal()));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (ANIMATION_STATES.equals(key)) {
            this.stopAll();
            switch (this.getState().ordinal()) {
                case 0: {
                    this.flyingAnimationState.m_216982_(this.f_146733_);
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216982_(this.f_146733_);
                    break;
                }
                case 5: {
                    this.takingOffAnimationState.m_216982_(this.f_146733_);
                    break;
                }
                case 4: {
                    this.landingAnimationState.m_216982_(this.f_146733_);
                    break;
                }
                case 2: {
                    this.fuzzUpFlyingAnimationState.m_216982_(this.f_146733_);
                    break;
                }
                case 3: {
                    this.fuzzUpIdleAnimationState.m_216982_(this.f_146733_);
                }
            }
        }
        super.m_7350_(key);
    }

    public void stopAll() {
        this.flyingAnimationState.m_216973_();
        this.idleAnimationState.m_216973_();
        this.fuzzUpFlyingAnimationState.m_216973_();
        this.fuzzUpIdleAnimationState.m_216973_();
        this.landingAnimationState.m_216973_();
        this.takingOffAnimationState.m_216973_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            this.setSheared();
        }
        return super.m_6469_(source, amount);
    }

    public InteractionResult m_6071_(Player player2, InteractionHand hand) {
        ItemStack itemStack = player2.m_21120_(hand);
        if (itemStack.m_204117_(CommonPlatform.getShearsTag())) {
            if (!this.m_9236_().f_46443_ && this.m_6220_()) {
                this.m_5851_(SoundSource.PLAYERS);
                this.m_146852_(GameEvent.f_157781_, (Entity)player2);
                itemStack.m_41622_(1, (LivingEntity)player2, player -> player.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player2, hand);
    }

    public void m_5851_(SoundSource source) {
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, source, 1.0f, 1.0f);
        this.setSheared();
        int i = 1 + this.f_19796_.m_188503_(3);
        for (int j = 0; j < i; ++j) {
            ItemEntity itemEntity = this.m_5552_(EstrogenItems.MOTH_FUZZ.asStack(), 0.5f);
            if (itemEntity == null) continue;
            itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public boolean m_6220_() {
        return this.m_6084_() && this.isFuzzy() && !this.m_6162_();
    }

    public int getTicksToFuzzUp() {
        if (this.ticksToFuzzUp == 0) {
            this.ticksToFuzzUp = this.f_19796_.m_216332_(12000, 36000);
        }
        return this.ticksToFuzzUp;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("TicksToFuzzUp", this.getTicksToFuzzUp());
        compound.m_128379_("Fuzzy", this.isFuzzy());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.ticksToFuzzUp = compound.m_128451_("TicksToFuzzUp");
        this.setFuzzy(compound.m_128471_("Fuzzy"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FUZZY, (Object)false);
    }

    public boolean isFuzzy() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FUZZY);
    }

    public void setFuzzy(boolean fuzzy) {
        this.f_19804_.m_135381_(DATA_FUZZY, (Object)fuzzy);
    }

    public void setFuzzy() {
        this.setFuzzy(true);
    }

    public void setSheared() {
        this.setFuzzy(false);
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        if (level.m_8055_(pos).m_60795_()) {
            return 10.0f;
        }
        return 0.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptByLightBlockGoal(this, 1.0, 5));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_(EstrogenTags.Items.LIGHT_EMITTERS), false));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_(EstrogenTags.Items.LEATHER_ITEMS), false));
        this.f_21345_.m_25352_(6, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        flyingPathNavigation.m_26440_(false);
        flyingPathNavigation.m_7008_(false);
        flyingPathNavigation.m_26443_(true);
        return flyingPathNavigation;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(EstrogenTags.Items.LEATHER_ITEMS);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)EstrogenSounds.MOTH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)EstrogenSounds.MOTH_DEATH.get();
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public MothEntity getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return (MothEntity)((EntityType)EstrogenEntities.MOTH.get()).m_20615_((Level)level);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        if (this.m_6162_()) {
            return dimensions.f_20378_ * 0.25f;
        }
        return dimensions.f_20378_ * 0.5f;
    }

    public boolean m_142039_() {
        return this.m_29443_() && this.f_19797_ % 2 == 0;
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_203347_(TagKey<Fluid> fluidTag) {
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.5f * this.m_20192_()), (double)(this.m_20205_() * 0.2f));
    }

    public static enum State {
        FLYING,
        IDLE,
        FUZZUP_FLYING,
        FUZZUP_IDLE,
        LANDING,
        TAKING_OFF;

    }
}

