/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.registry.blocks;

import dev.mayaqq.estrogen.client.features.dash.ClientDash;
import dev.mayaqq.estrogen.features.dash.CommonDash;
import dev.mayaqq.estrogen.registry.EstrogenBlockEntities;
import dev.mayaqq.estrogen.registry.blockEntities.DreamBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import uwu.serenity.critter.utils.BEBlock;

public class DreamBlock
extends BaseEntityBlock
implements BEBlock<DreamBlockEntity> {
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static Vec3 lookAngle = null;

    public DreamBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST});
    }

    public boolean m_5946_(BlockState state, Fluid fluid) {
        return false;
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Player player;
        EntityCollisionContext entityCollisionContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityCollisionContext = (EntityCollisionContext)context).m_193113_()) instanceof Player && (CommonDash.isPlayerDashing((player = (Player)entity).m_20148_()) || DreamBlock.isInDreamBlock(player))) {
            return Shapes.m_83040_();
        }
        return Shapes.m_83144_();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof DreamBlockEntity) {
            DreamBlockEntity dream = (DreamBlockEntity)be;
            if (level.m_5776_()) {
                dream.updateTexture(direction.m_122434_() != Direction.Axis.Y);
            }
        }
        if (neighborState.m_60713_((Block)this)) {
            return (BlockState)state.m_61124_((Property)DreamBlock.directionProperty(direction), (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.m_61124_((Property)DreamBlock.directionProperty(direction), (Comparable)Boolean.valueOf(false));
    }

    public static BooleanProperty directionProperty(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
        };
    }

    public static boolean isInDreamBlock(Player player) {
        if (player.m_5833_()) {
            return false;
        }
        AABB playerAABB = player.m_20191_();
        BlockPos minPos = BlockPos.m_274561_((double)playerAABB.f_82288_, (double)playerAABB.f_82289_, (double)playerAABB.f_82290_);
        BlockPos maxPos = new BlockPos(Mth.m_14165_((double)playerAABB.f_82291_) - 1, Mth.m_14165_((double)playerAABB.f_82292_) - 1, Mth.m_14165_((double)playerAABB.f_82293_) - 1);
        return BlockPos.m_121990_((BlockPos)minPos, (BlockPos)maxPos).anyMatch(pos -> player.m_9236_().m_8055_(pos).m_60734_() instanceof DreamBlock);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        entity.m_183634_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (level.f_46443_) {
                ClientDash.refresh(player);
                if (lookAngle == null) {
                    lookAngle = player.m_20154_();
                }
                player.m_20256_(lookAngle.m_82490_(2.0));
            }
        }
    }

    public BlockEntityType<? extends DreamBlockEntity> getBlockEntityType() {
        return (BlockEntityType)EstrogenBlockEntities.DREAM_BLOCK.get();
    }

    public Class<? extends DreamBlockEntity> getBlockEntityClass() {
        return DreamBlockEntity.class;
    }
}

