/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.registry.blocks;

import dev.mayaqq.estrogen.registry.EstrogenAdvancementCriteria;
import dev.mayaqq.estrogen.registry.EstrogenBlockEntities;
import dev.mayaqq.estrogen.registry.EstrogenSoundTypes;
import dev.mayaqq.estrogen.registry.EstrogenSounds;
import dev.mayaqq.estrogen.registry.blockEntities.CookieJarBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import uwu.serenity.critter.utils.BEBlock;

public class CookieJarBlock
extends BaseEntityBlock
implements BEBlock<CookieJarBlockEntity>,
SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED;
    private static final VoxelShape BOUNDING_BOX;

    public CookieJarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        FluidState fluidState = blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof CookieJarBlockEntity)) {
            return InteractionResult.PASS;
        }
        CookieJarBlockEntity cookieJarBlockEntity = (CookieJarBlockEntity)blockEntity;
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        ItemStack handItem = player.m_21120_(hand);
        if (!handItem.m_41619_()) {
            ItemStack remainder = cookieJarBlockEntity.addItemStack(handItem);
            if (ItemStack.m_41728_((ItemStack)handItem, (ItemStack)remainder)) {
                level.m_5594_(null, pos, (SoundEvent)EstrogenSounds.JAR_FULL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                if (!player.m_7500_()) {
                    handItem.m_41764_(remainder.m_41613_());
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)handItem.m_41720_()));
                level.m_5594_(null, pos, (SoundEvent)EstrogenSounds.JAR_INSERT.get(), SoundSource.BLOCKS, 1.0f, 0.7f + 0.5f * ((float)cookieJarBlockEntity.getCount() / 512.0f));
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    EstrogenAdvancementCriteria.INSERT_JAR.trigger((ServerPlayer)player);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
                }
            }
        } else {
            ItemStack jarItemStack;
            ItemStack itemStack = jarItemStack = player.m_6144_() ? cookieJarBlockEntity.removeItemStack() : cookieJarBlockEntity.remove1Item();
            if (!jarItemStack.m_41619_()) {
                level.m_5594_(null, pos, (SoundEvent)EstrogenSounds.JAR_INSERT.get(), SoundSource.BLOCKS, 1.0f, 0.7f + 0.5f * ((float)cookieJarBlockEntity.getCount() / 512.0f));
                if (level instanceof ServerLevel) {
                    player.m_150109_().m_150079_(jarItemStack);
                }
            }
        }
        level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
        return InteractionResult.SUCCESS;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return BOUNDING_BOX;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public void m_6810_(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean bl) {
        CookieJarBlockEntity be = (CookieJarBlockEntity)this.getBlockEntity((BlockGetter)level, blockPos);
        if (!state.m_60713_(newState.m_60734_()) && be != null) {
            Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)be);
        }
        super.m_6810_(state, level, blockPos, newState, bl);
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public SoundType m_49962_(BlockState blockState) {
        return EstrogenSoundTypes.COOKIE_JAR;
    }

    public void m_5581_(Level level, BlockState blockState, BlockHitResult blockHitResult, Projectile projectile) {
        BlockPos blockPos = blockHitResult.m_82425_();
        if (!level.f_46443_ && projectile.m_142265_(level, blockPos)) {
            level.m_46953_(blockPos, true, (Entity)projectile);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.625, (double)0.375, (double)0.625, (double)0.8125, (double)0.625), (BooleanOp)BooleanOp.f_82689_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.6875, (double)0.25, (double)0.75, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.625, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.625, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public BlockEntityType<? extends CookieJarBlockEntity> getBlockEntityType() {
        return (BlockEntityType)EstrogenBlockEntities.COOKIE_JAR.get();
    }

    public Class<? extends CookieJarBlockEntity> getBlockEntityClass() {
        return CookieJarBlockEntity.class;
    }

    static {
        BOUNDING_BOX = CookieJarBlock.makeShape();
        WATERLOGGED = BlockStateProperties.f_61362_;
    }
}

