/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.registry.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.mayaqq.estrogen.Estrogen;
import dev.mayaqq.estrogen.registry.particles.DashTrailParticleOptions;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class DashTrailParticle
extends Particle {
    private static final ResourceLocation WHITE_TEXTURE = Estrogen.id("textures/misc/pixel.png");
    private static final ParticleRenderType DASH_PLAYER = new ParticleRenderType(){

        public void m_6505_(BufferBuilder builder, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)WHITE_TEXTURE);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
        }

        public String toString() {
            return "DashPlayerParticle";
        }
    };
    private final PoseStack matrices = new PoseStack();
    private final float[] vertices;
    private final boolean isLocalPlayer;
    private final float yRot;
    private final int vertexCount;
    private final float r;
    private final float g;
    private final float b;

    public DashTrailParticle(DashTrailParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this(level, x, y, z, (LivingEntity)level.m_46003_(options.playerUUID()), options.r(), options.g(), options.b());
    }

    protected DashTrailParticle(ClientLevel level, double x, double y, double z, LivingEntity entity, float r, float g, float b) {
        super(level, x, y, z);
        this.r = r;
        this.g = g;
        this.b = b;
        this.f_107219_ = false;
        this.m_107259_(entity.m_20191_());
        this.m_107257_(15);
        this.yRot = entity.f_20883_ + 180.0f;
        this.isLocalPlayer = entity == Minecraft.m_91087_().m_91288_();
        LivingEntityRenderer renderer = (LivingEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
        ModelConsumer consumer = new ModelConsumer();
        this.matrices.m_85836_();
        renderer.m_7200_().f_102610_ = entity.m_6162_();
        renderer.m_7200_().m_7695_(this.matrices, (VertexConsumer)consumer, 0, OverlayTexture.f_118083_, 255.0f, 255.0f, 255.0f, 255.0f);
        this.matrices.m_85849_();
        this.vertices = consumer.data;
        this.vertexCount = consumer.vertexCount;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vec3 pos = renderInfo.m_90583_();
        if (this.isLocalPlayer && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && pos.m_82531_(this.f_107212_, this.f_107213_, this.f_107214_) < 4.0) {
            return;
        }
        float x = (float)(this.f_107212_ - pos.m_7096_());
        float y = (float)(this.f_107213_ - pos.m_7098_());
        float z = (float)(this.f_107214_ - pos.m_7094_());
        this.matrices.m_85836_();
        this.matrices.m_252880_(x, y + 1.5f, z);
        this.matrices.m_85841_(-1.0f, -1.0f, 1.0f);
        this.matrices.m_252781_(Axis.f_252436_.m_252977_(this.yRot));
        float alpha = 1.0f - Mth.m_14179_((float)partialTicks, (float)Math.max(this.f_107224_ - 1, 0), (float)this.f_107224_) / (float)this.f_107225_;
        for (int i = 0; i < this.vertexCount; ++i) {
            int v = i * 3;
            buffer.m_252986_(this.matrices.m_85850_().m_252922_(), this.vertices[v], this.vertices[v + 1], this.vertices[v + 2]).m_7421_(DashTrailParticle.uForVertex(i), DashTrailParticle.vForVertex(i)).m_85950_(this.r, this.g, this.b, alpha).m_85969_(0xF000F0).m_5752_();
        }
        this.matrices.m_85849_();
    }

    private static float uForVertex(int v) {
        int i = v % 4;
        return i == 2 || i == 3 ? 1.0f : 0.0f;
    }

    private static float vForVertex(int v) {
        return v % 2 == 0 ? 1.0f : 0.0f;
    }

    public ParticleRenderType m_7556_() {
        return DASH_PLAYER;
    }

    private static class ModelConsumer
    implements VertexConsumer {
        private static final int STRIDE = 3;
        private float[] data = new float[12];
        private int position = 0;
        private int vertexCount;
        private int capacity = 4;

        private ModelConsumer() {
        }

        public VertexConsumer m_5483_(double x, double y, double z) {
            this.data[this.position] = (float)x;
            this.data[this.position + 1] = (float)y;
            this.data[this.position + 2] = (float)z;
            return this;
        }

        public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
            return this;
        }

        public VertexConsumer m_7421_(float u, float v) {
            return this;
        }

        public VertexConsumer m_7122_(int u, int v) {
            return this;
        }

        public VertexConsumer m_7120_(int u, int v) {
            return this;
        }

        public VertexConsumer m_5601_(float x, float y, float z) {
            return this;
        }

        public void m_5752_() {
            this.position += 3;
            ++this.vertexCount;
            if (this.vertexCount >= this.capacity) {
                this.capacity += 4;
                float[] newData = new float[this.capacity * 3];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                this.data = newData;
            }
        }

        public void m_7404_(int defaultR, int defaultG, int defaultB, int defaultA) {
        }

        public void m_141991_() {
        }
    }
}

