/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock.texture.advanced;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.List;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import org.joml.Math;

public class Goober {
    static final SimpleWeightedRandomList<Integer> TRANSPARENCY = new SimpleWeightedRandomList.Builder().m_146271_((Object)0, 5).m_146271_((Object)1, 2).m_146271_((Object)2, 1).m_146270_();
    private final int x;
    private final int y;
    private final Color color;
    private final Style style;
    private final int frameTick;
    private final int transparencyLevel;
    private int currentFrame;

    public Goober(int x, int y, Color color, Style style, int frameTick, int beginFrame, int transparencyLevel) {
        this.x = x;
        this.y = y;
        this.color = color;
        this.style = style;
        this.frameTick = frameTick;
        this.currentFrame = beginFrame;
        this.transparencyLevel = transparencyLevel;
    }

    public boolean tooClose(int x, int y) {
        int difX = Math.abs((int)(this.x - x));
        int difY = Math.abs((int)(this.y - y));
        if (this.style == Style.PIXEL) {
            return difX < 2 && difY < 2;
        }
        return difX < 8 && difY < 8 || difX < 6 || difY < 6;
    }

    public void draw(NativeImage pixels) {
        int col = this.color.color;
        switch (this.transparencyLevel) {
            case 1: {
                col = FastColor.ARGB32.m_13657_((int)col, (int)-16777217);
                col = FastColor.ARGB32.m_13657_((int)col, (int)-16777217);
            }
            case 2: {
                col = FastColor.ARGB32.m_13657_((int)col, (int)-16777217);
                col = FastColor.ARGB32.m_13657_((int)col, (int)-16777217);
                col = FastColor.ARGB32.m_13657_((int)col, (int)-16777217);
            }
        }
        this.style.draw(pixels, this.x, this.y, col, this.currentFrame);
    }

    public boolean tickAnimation(int tick) {
        if (tick == this.frameTick) {
            ++this.currentFrame;
            if (this.currentFrame == this.style.frameCount()) {
                this.currentFrame = 0;
            }
            return true;
        }
        return false;
    }

    public static enum Color {
        YELLOW(Color.rgb(255, 255, 0)),
        CYAN(Color.rgb(0, 241, 254)),
        PURPLE(Color.rgb(126, 126, 218)),
        MAGENTA(Color.rgb(255, 71, 231)),
        GREEN1(Color.rgb(60, 145, 97)),
        GREEN2(Color.rgb(40, 198, 53));

        final int color;

        private Color(int color) {
            this.color = color;
        }

        public static int rgb(int r, int g, int b) {
            return FastColor.ARGB32.m_13660_((int)255, (int)b, (int)g, (int)r);
        }
    }

    public static enum Style implements WeightedEntry
    {
        PIXEL(2, List.of(NativeImage::m_84988_)),
        STAR(5, List.of((image, x, y, color) -> {
            image.m_84988_(x + 1, y, color);
            image.m_84988_(x, y + 1, color);
            image.m_84988_(x - 1, y, color);
            image.m_84988_(x, y - 1, color);
        })),
        THINGY(2, List.of((pixels, x, y, col) -> {
            pixels.m_84988_(x + 1, y, col);
            pixels.m_84988_(x, y + 1, col);
            pixels.m_84988_(x - 1, y, col);
            pixels.m_84988_(x, y - 1, col);
            int transCol = FastColor.ARGB32.m_13657_((int)col, (int)-23488103);
            pixels.m_84988_(x + 1, y + 1, transCol);
            pixels.m_84988_(x - 1, y - 1, transCol);
        })),
        STAR_ANIMATED(3, List.of((image, x, y, color) -> {
            image.m_84988_(x + 1, y, color);
            image.m_84988_(x, y + 1, color);
            image.m_84988_(x - 1, y, color);
            image.m_84988_(x, y - 1, color);
        }, (image, x, y, color) -> {
            image.m_84988_(x + 1, y, color);
            image.m_84988_(x, y + 1, color);
            image.m_84988_(x - 1, y, color);
            image.m_84988_(x, y - 1, color);
            image.m_84988_(x + 2, y, color);
            image.m_84988_(x - 2, y, color);
            image.m_84988_(x, y + 2, color);
            image.m_84988_(x, y - 2, color);
            int transCol = FastColor.ARGB32.m_13657_((int)color, (int)-23488103);
            image.m_84988_(x + 1, y + 1, transCol);
            image.m_84988_(x - 1, y - 1, transCol);
            image.m_84988_(x - 1, y + 1, transCol);
            image.m_84988_(x + 1, y - 1, transCol);
        }));

        final Weight weight;
        final List<DrawFunction> frames;
        private static final WeightedRandomList<Style> weightedRandomList;

        private Style(int weight, List<DrawFunction> frames) {
            this.weight = Weight.m_146282_((int)weight);
            this.frames = frames;
        }

        void draw(NativeImage image, int x, int y, int color, int frame) {
            this.frames.get(frame).draw(image, x, y, color);
        }

        public int frameCount() {
            return this.frames.size();
        }

        public boolean hasAnimation() {
            return this.frames.size() > 1;
        }

        public Weight m_142631_() {
            return this.weight;
        }

        public static Style weighted(RandomSource rng) {
            return (Style)((Object)weightedRandomList.m_216829_(rng).get());
        }

        static {
            weightedRandomList = WeightedRandomList.m_146330_((WeightedEntry[])Style.values());
        }

        static interface DrawFunction {
            public void draw(NativeImage var1, int var2, int var3, int var4);
        }
    }
}

