/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock.texture.advanced;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.mayaqq.estrogen.client.registry.EstrogenRenderType;
import dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock.DreamBlockRenderer;
import dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock.texture.advanced.Goober;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;

public class DynamicDreamTexture {
    public static final DynamicDreamTexture INSTANCE = new DynamicDreamTexture();
    public static boolean enableAnimation = true;
    private static final AtomicBoolean shouldAnimate = new AtomicBoolean();
    private final List<Goober> goobers = new ObjectArrayList();
    private DynamicTexture texture;
    private ResourceLocation texID;
    private RenderType renderType;
    private long seed = 80085L;
    private int animationTick = 0;
    private boolean init = false;

    public void prepare() {
        if (this.init) {
            return;
        }
        this.texture = new DynamicTexture(128, 128, false);
        this.texID = Minecraft.m_91087_().m_91097_().m_118490_("dreamy", this.texture);
        this.renderType = EstrogenRenderType.DREAM_BLOCK.apply(this.texID);
        this.draw();
        this.init = true;
    }

    private void _release() {
        if (!this.init) {
            return;
        }
        Minecraft.m_91087_().m_91097_().m_118513_(this.texID);
        this.texture = null;
        this.texID = null;
        this.renderType = null;
        this.init = false;
    }

    public void release() {
        if (RenderSystem.isOnRenderThread()) {
            this._release();
        } else {
            RenderSystem.recordRenderCall(this::_release);
        }
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public void changeSeed(long seed) {
        this.seed = seed;
        this.generateGoobers();
        this.redraw();
    }

    public void generateGoobers() {
        RandomSource random = RandomSource.m_216335_((long)this.seed);
        if (!this.goobers.isEmpty()) {
            this.goobers.clear();
        }
        int count = random.m_216332_(50, 60);
        int attempts = 16;
        while (count > 0) {
            boolean canPlace = true;
            int posX = random.m_216339_(4, 124);
            int posY = random.m_216339_(4, 124);
            for (Goober goob : this.goobers) {
                if (!goob.tooClose(posX, posY)) continue;
                canPlace = false;
                break;
            }
            if (canPlace) {
                Goober.Style style = Goober.Style.weighted(random);
                Goober.Color color = Goober.Color.values()[random.m_216332_(0, 5)];
                int animTick = style.hasAnimation() ? random.m_216332_(0, 10) : 0;
                int beginFrame = random.m_216339_(0, style.frameCount());
                int transparency = Goober.TRANSPARENCY.m_216829_(random).map(WeightedEntry.Wrapper::m_146310_).orElse(0);
                Goober goober = new Goober(posX, posY, color, style, animTick, beginFrame, transparency);
                this.goobers.add(goober);
                --count;
                continue;
            }
            if (--attempts != 0) continue;
            --count;
            attempts = 16;
        }
    }

    protected void draw() {
        NativeImage pixels = this.texture.m_117991_();
        pixels.m_284481_(i -> -16777216);
        for (Goober goober : this.goobers) {
            goober.draw(pixels);
        }
        this.texture.m_117985_();
    }

    public void tick() {
        ++this.animationTick;
        if (this.animationTick == 10) {
            this.animationTick = 0;
        }
        boolean redraw = false;
        for (Goober goober : this.goobers) {
            if (!goober.tickAnimation(this.animationTick)) continue;
            redraw = true;
        }
        if (this.shouldAnimate() && redraw) {
            this.redraw();
        }
    }

    public void redraw() {
        if (!this.init) {
            return;
        }
        if (RenderSystem.isOnRenderThread()) {
            this.draw();
        } else {
            RenderSystem.recordRenderCall(this::draw);
        }
    }

    private boolean shouldAnimate() {
        return enableAnimation && DreamBlockRenderer.useAdvancedRenderer() && shouldAnimate.get();
    }

    public static void setActive() {
        shouldAnimate.set(true);
    }

    public static void resetActive() {
        shouldAnimate.set(false);
    }
}

