/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock.texture;

import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.mayaqq.estrogen.config.EstrogenConfig;
import dev.mayaqq.estrogen.registry.EstrogenBlocks;
import dev.mayaqq.estrogen.registry.blockEntities.DreamBlockEntity;
import dev.mayaqq.estrogen.utils.DynamicTextureMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class DreamBlockTexture {
    public static int maxAnimTick = 30;
    public static int currentAnimationTick = 0;
    private final DynamicTextureMap map;
    private final DreamBlockEntity blockEntity;
    private final Map<Direction, Set<Goober>> goobers = new Object2ObjectArrayMap(6);
    private final RandomSource random;
    private static final SimpleWeightedRandomList<Object> transparency = new SimpleWeightedRandomList.Builder().m_146271_((Object)0, 5).m_146271_((Object)1, 2).m_146271_((Object)2, 1).m_146270_();

    public DreamBlockTexture(DreamBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        this.map = new DynamicTextureMap(16);
        BlockPos pos = blockEntity.m_58899_();
        this.random = RandomSource.m_216335_((long)((long)pos.m_123341_() + (long)pos.m_123342_() * 111L + (long)pos.m_123343_() * 17L));
    }

    public static void animationTick() {
        if (++currentAnimationTick > maxAnimTick) {
            currentAnimationTick = 0;
        }
    }

    public void init() {
        this.populateNodes();
        this.map.init(Minecraft.m_91087_().m_91097_(), "dream_block");
        this.map.drawAll(this::draw);
    }

    public void animate() {
        if (!((Boolean)EstrogenConfig.client().animateTexture.get()).booleanValue()) {
            return;
        }
        int ct = currentAnimationTick;
        for (Direction direction : Direction.values()) {
            for (Goober goober : this.goobers.get(direction)) {
                if (ct != goober.startTick() && ct != goober.endTick()) continue;
                this.map.draw(direction, this::draw);
            }
        }
    }

    public void redraw() {
        this.map.drawAll(this::draw);
    }

    public void renderFace(Matrix4f pose, VertexConsumer consumer, float x0, float x1, float y0, float y1, float z0, float z1, float z2, float z3, Direction direction, boolean cull) {
        Level level = this.blockEntity.m_58904_();
        BlockPos pos = this.blockEntity.m_58899_();
        if (cull && level != null && level.m_8055_(pos.m_121945_(direction)).m_60713_((Block)EstrogenBlocks.DREAM_BLOCK.get())) {
            return;
        }
        consumer.m_252986_(pose, x0, y0, z0).m_193479_(-1).m_7421_(this.map.getU0(direction), this.map.getV0(direction)).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.normal(new Matrix3f()), 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, x1, y0, z1).m_193479_(-1).m_7421_(this.map.getU1(direction), this.map.getV0(direction)).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.normal(new Matrix3f()), 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, x1, y1, z2).m_193479_(-1).m_7421_(this.map.getU1(direction), this.map.getV1(direction)).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.normal(new Matrix3f()), 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, x0, y1, z3).m_193479_(-1).m_7421_(this.map.getU0(direction), this.map.getV1(direction)).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.normal(new Matrix3f()), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public DynamicTextureMap getTextureMap() {
        return this.map;
    }

    public RenderType getRenderType() {
        return RenderType.m_110470_((ResourceLocation)this.map.location());
    }

    private void populateNodes() {
        for (Direction dir : Direction.values()) {
            if (!this.goobers.containsKey(dir)) {
                this.goobers.put(dir, (Set<Goober>)new ObjectArraySet());
            }
            int nodeCount = this.random.m_216332_(6, 12);
            for (int i = 0; i < nodeCount; ++i) {
                GooberColor color = GooberColor.values()[this.random.m_216332_(0, 5)];
                GooberStyle style = GooberStyle.weighted(this.random);
                int posX = this.random.m_216339_(0, 16);
                int posY = this.random.m_216339_(0, 16);
                int startTick = 0;
                int endTick = 0;
                boolean reverse = false;
                if (posY > 2 && posX < 14 && posX > 2 && posY < 14) {
                    boolean hasAnim = style == GooberStyle.STAR_ANIMATED;
                    startTick = hasAnim ? this.random.m_216332_(0, maxAnimTick / 2) : -1;
                    endTick = hasAnim ? startTick + maxAnimTick / 2 : -1;
                    reverse = this.random.m_188499_();
                }
                Goober goober = new Goober(posX, posY, color, style, startTick, endTick, reverse, DreamBlockTexture.getTransparency(this.random));
                this.goobers.get(dir).add(goober);
            }
        }
    }

    private void draw(DynamicTextureMap.DrawContext ctx) {
        BlockPos pos = this.blockEntity.m_58899_();
        Level level = this.blockEntity.m_58904_();
        if (level != null && level.m_8055_(pos.m_121945_(ctx.face())).m_60713_((Block)EstrogenBlocks.DREAM_BLOCK.get())) {
            return;
        }
        ctx.applyToPixels(i -> -300941307);
        for (Goober goober : this.goobers.get(ctx.face())) {
            goober.draw(ctx, currentAnimationTick);
        }
        this.drawBorder(ctx);
    }

    private void drawBorder(DynamicTextureMap.DrawContext ctx) {
        BiPredicate<Integer, Integer> connect = this.connectedBorder(this.blockEntity, ctx.face());
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                if (!connect.test(x, y)) continue;
                ctx.setPixelColor(x, y, -1);
            }
        }
    }

    protected Direction getUpDirection(Direction face) {
        Direction.Axis axis = face.m_122434_();
        return axis.m_122479_() ? Direction.UP : Direction.NORTH;
    }

    protected Direction getRightDirection(Direction face) {
        Direction.Axis axis = face.m_122434_();
        return axis == Direction.Axis.X ? Direction.SOUTH : Direction.WEST;
    }

    private BiPredicate<Integer, Integer> connectedBorder(DreamBlockEntity be, Direction face) {
        BlockPos pos = be.m_58899_();
        Level level = be.m_58904_();
        Block dreamBlock = (Block)EstrogenBlocks.DREAM_BLOCK.get();
        BiPredicate<Integer, Integer> output = (x, y) -> false;
        boolean positive = face.m_122421_() == Direction.AxisDirection.POSITIVE;
        Direction right = this.getRightDirection(face);
        Direction up = this.getUpDirection(face);
        if (face.m_122434_() == Direction.Axis.X) {
            up = up.m_122424_();
            right = right.m_122424_();
        }
        Direction direction = up = positive ? up.m_122424_() : up;
        if (level == null) {
            return output;
        }
        boolean stateR = be.isTouchingDreamBlock(right);
        boolean stateL = be.isTouchingDreamBlock(right.m_122424_());
        boolean stateUp = be.isTouchingDreamBlock(up);
        boolean stateDown = be.isTouchingDreamBlock(up.m_122424_());
        if (!stateL) {
            output = output.or((x, y) -> x == 15);
        }
        if (!stateR) {
            output = output.or((x, y) -> x == 0);
        }
        if (!stateDown) {
            output = output.or((x, y) -> y == 15);
        }
        if (!stateUp) {
            output = output.or((x, y) -> y == 0);
        }
        BlockState cornerUpRight = level.m_8055_(pos.m_121945_(up).m_121945_(right));
        BlockState cornerUpLeft = level.m_8055_(pos.m_121945_(up).m_121945_(right.m_122424_()));
        BlockState cornerDownRight = level.m_8055_(pos.m_121945_(up.m_122424_()).m_121945_(right));
        BlockState corderDownLeft = level.m_8055_(pos.m_121945_(up.m_122424_()).m_121945_(right.m_122424_()));
        if (!cornerUpLeft.m_60713_(dreamBlock)) {
            output = output.or((x, y) -> x == 15 && y == 0);
        }
        if (!cornerUpRight.m_60713_(dreamBlock)) {
            output = output.or((x, y) -> x == 0 && y == 0);
        }
        if (!corderDownLeft.m_60713_(dreamBlock)) {
            output = output.or((x, y) -> x == 15 && y == 15);
        }
        if (!cornerDownRight.m_60713_(dreamBlock)) {
            output = output.or((x, y) -> x == 0 && y == 15);
        }
        return output;
    }

    public static int getTransparency(RandomSource rng) {
        return (Integer)((WeightedEntry.Wrapper)transparency.m_216829_(rng).get()).m_146310_();
    }

    private record Goober(int x, int y, GooberColor color, GooberStyle style, int startTick, int endTick, boolean reverse, int lessOpacity) {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Goober) {
                Goober n = (Goober)obj;
                return this.effectivelyEqual(n);
            }
            return false;
        }

        public boolean effectivelyEqual(Goober goober) {
            int difX = Math.abs((int)(this.x - goober.x));
            int difY = Math.abs((int)(this.y - goober.y));
            return difX < 4 && difY < 4 || (difX < 2 || difY < 2) && this.style != GooberStyle.PIXEL;
        }

        public void draw(DynamicTextureMap.DrawContext context, int animTick) {
            int col = this.color.color;
            switch (this.lessOpacity) {
                case 1: {
                    col = FastColor.ARGB32.m_13657_((int)col, (int)-23488103);
                    col = FastColor.ARGB32.m_13657_((int)col, (int)-23488103);
                }
                case 2: {
                    col = FastColor.ARGB32.m_13657_((int)col, (int)-23488103);
                    col = FastColor.ARGB32.m_13657_((int)col, (int)-23488103);
                    col = FastColor.ARGB32.m_13657_((int)col, (int)-23488103);
                }
            }
            if (this.x < 15 && this.y < 15 && this.x > 0 && this.y > 0) {
                switch (this.style.ordinal()) {
                    case 0: {
                        context.setPixelColor(this.x, this.y, col);
                        break;
                    }
                    case 1: {
                        context.setPixelColor(this.x + 1, this.y, col);
                        context.setPixelColor(this.x, this.y + 1, col);
                        context.setPixelColor(this.x - 1, this.y, col);
                        context.setPixelColor(this.x, this.y - 1, col);
                        break;
                    }
                    case 3: {
                        context.setPixelColor(this.x + 1, this.y, col);
                        context.setPixelColor(this.x, this.y + 1, col);
                        context.setPixelColor(this.x - 1, this.y, col);
                        context.setPixelColor(this.x, this.y - 1, col);
                        if (!this.testAnimation(animTick)) break;
                        context.setPixelColorSafe(this.x + 2, this.y, col);
                        context.setPixelColorSafe(this.x - 2, this.y, col);
                        context.setPixelColorSafe(this.x, this.y + 2, col);
                        context.setPixelColorSafe(this.x, this.y - 2, col);
                        int transCol = FastColor.ARGB32.m_13657_((int)col, (int)-23488103);
                        context.setPixelColorSafe(this.x + 1, this.y + 1, transCol);
                        context.setPixelColorSafe(this.x - 1, this.y - 1, transCol);
                        context.setPixelColorSafe(this.x - 1, this.y + 1, transCol);
                        context.setPixelColorSafe(this.x + 1, this.y - 1, transCol);
                        break;
                    }
                    case 2: {
                        context.setPixelColor(this.x + 1, this.y, col);
                        context.setPixelColor(this.x, this.y + 1, col);
                        context.setPixelColor(this.x - 1, this.y, col);
                        context.setPixelColor(this.x, this.y - 1, col);
                        context.setPixelColor(this.x + 1, this.y + 1, col);
                        context.setPixelColor(this.x - 1, this.y - 1, col);
                    }
                }
            } else {
                context.setPixelColor(this.x, this.y, col);
            }
        }

        private boolean testAnimation(int tick) {
            return this.reverse != (tick >= this.startTick && tick < this.endTick);
        }
    }

    private static enum GooberColor {
        YELLOW(GooberColor.rgb(255, 255, 0)),
        CYAN(GooberColor.rgb(0, 241, 254)),
        PURPLE(GooberColor.rgb(66, 66, 158)),
        MAGENTA(GooberColor.rgb(255, 71, 231)),
        GREEN1(GooberColor.rgb(40, 125, 77)),
        GREEN2(GooberColor.rgb(0, 158, 13));

        final int color;

        private GooberColor(int color) {
            this.color = color;
        }

        public int red() {
            return FastColor.ARGB32.m_13665_((int)this.color);
        }

        public int green() {
            return FastColor.ARGB32.m_13667_((int)this.color);
        }

        public int blue() {
            return FastColor.ARGB32.m_13669_((int)this.color);
        }

        public static int rgb(int r, int g, int b) {
            return FastColor.ARGB32.m_13660_((int)255, (int)b, (int)g, (int)r);
        }
    }

    private static enum GooberStyle implements WeightedEntry
    {
        PIXEL(2),
        STAR(3),
        THINGY(1),
        STAR_ANIMATED(3);

        final Weight weight;
        private static final WeightedRandomList<GooberStyle> weightedRandomList;

        private GooberStyle(int weight) {
            this.weight = Weight.m_146282_((int)weight);
        }

        public Weight m_142631_() {
            return this.weight;
        }

        public static GooberStyle weighted(RandomSource rng) {
            return (GooberStyle)((Object)weightedRandomList.m_216829_(rng).get());
        }

        static {
            weightedRandomList = WeightedRandomList.m_146330_((WeightedEntry[])GooberStyle.values());
        }
    }
}

