/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.mayaqq.estrogen.client.ShaderHelper;
import dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock.texture.DreamBlockTexture;
import dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock.texture.advanced.DynamicDreamTexture;
import dev.mayaqq.estrogen.config.DreamBlockRenderState;
import dev.mayaqq.estrogen.config.EstrogenConfig;
import dev.mayaqq.estrogen.registry.blockEntities.DreamBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class DreamBlockRenderer
extends SafeBlockEntityRenderer<DreamBlockEntity> {
    public DreamBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static boolean useAdvancedRenderer() {
        try {
            return switch ((DreamBlockRenderState)((Object)EstrogenConfig.client().advancedRendering.get())) {
                default -> throw new IncompatibleClassChangeError();
                case DreamBlockRenderState.ALWAYS -> true;
                case DreamBlockRenderState.NEVER -> false;
                case DreamBlockRenderState.DEFAULT -> !ShaderHelper.isShaderPackInUse();
            };
        }
        catch (NullPointerException e) {
            return !ShaderHelper.isShaderPackInUse();
        }
    }

    public void renderSafe(@NotNull DreamBlockEntity be, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        if (DreamBlockRenderer.useAdvancedRenderer()) {
            if (be.getTexture() != null) {
                be.setTexture(null);
            }
            DynamicDreamTexture.INSTANCE.prepare();
            DynamicDreamTexture.setActive();
            this.renderCubeShader(be, matrix4f, multiBufferSource.m_6299_(DynamicDreamTexture.INSTANCE.getRenderType()));
        } else {
            if (be.getTexture() == null) {
                be.setTexture(new DreamBlockTexture(be));
            }
            DreamBlockTexture texture = be.getTexture();
            this.renderCube(texture, matrix4f, multiBufferSource.m_6299_(texture.getRenderType()));
            texture.animate();
        }
    }

    private void renderCube(DreamBlockTexture texture, Matrix4f pose, VertexConsumer consumer) {
        texture.renderFace(pose, consumer, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, Direction.SOUTH, true);
        texture.renderFace(pose, consumer, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Direction.NORTH, true);
        texture.renderFace(pose, consumer, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, Direction.EAST, true);
        texture.renderFace(pose, consumer, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, Direction.WEST, true);
        texture.renderFace(pose, consumer, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, Direction.DOWN, true);
        texture.renderFace(pose, consumer, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, Direction.UP, true);
    }

    private void renderCubeShader(DreamBlockEntity blockEntity, Matrix4f pose, VertexConsumer consumer) {
        this.renderFaceShader(blockEntity, pose, consumer, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, Direction.SOUTH);
        this.renderFaceShader(blockEntity, pose, consumer, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Direction.NORTH);
        this.renderFaceShader(blockEntity, pose, consumer, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, Direction.EAST);
        this.renderFaceShader(blockEntity, pose, consumer, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, Direction.WEST);
        this.renderFaceShader(blockEntity, pose, consumer, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, Direction.DOWN);
        this.renderFaceShader(blockEntity, pose, consumer, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, Direction.UP);
    }

    private void renderFaceShader(DreamBlockEntity blockEntity, Matrix4f pose, VertexConsumer consumer, float x0, float x1, float y0, float y1, float z0, float z1, float z2, float z3, Direction direction) {
        this.addInnerVertexShader(blockEntity, pose, consumer, x0, y0, z0);
        this.addInnerVertexShader(blockEntity, pose, consumer, x1, y0, z1);
        this.addInnerVertexShader(blockEntity, pose, consumer, x1, y1, z2);
        this.addInnerVertexShader(blockEntity, pose, consumer, x0, y1, z3);
        if (!blockEntity.isTouchingDreamBlock(direction)) {
            this.addOuterVertexShader(blockEntity, pose, consumer, x0, y1, z3);
            this.addOuterVertexShader(blockEntity, pose, consumer, x1, y1, z2);
            this.addOuterVertexShader(blockEntity, pose, consumer, x1, y0, z1);
            this.addOuterVertexShader(blockEntity, pose, consumer, x0, y0, z0);
        }
    }

    private void addInnerVertexShader(DreamBlockEntity blockEntity, Matrix4f pose, VertexConsumer consumer, float x, float y, float z) {
        float x2 = blockEntity.isTouchingDreamBlock((double)x > 0.5 ? Direction.EAST : Direction.WEST) ? x : x * 7.0f / 8.0f + 0.0625f;
        float y2 = blockEntity.isTouchingDreamBlock((double)y > 0.5 ? Direction.UP : Direction.DOWN) ? y : y * 7.0f / 8.0f + 0.0625f;
        float z2 = blockEntity.isTouchingDreamBlock((double)z > 0.5 ? Direction.SOUTH : Direction.NORTH) ? z : z * 7.0f / 8.0f + 0.0625f;
        this.addVertexShader(pose, consumer, x2, y2, z2, false);
    }

    private void addOuterVertexShader(DreamBlockEntity blockEntity, Matrix4f pose, VertexConsumer consumer, float x, float y, float z) {
        float x2 = x * 0.999f + 5.0E-4f;
        float y2 = y * 0.999f + 5.0E-4f;
        float z2 = z * 0.999f + 5.0E-4f;
        this.addVertexShader(pose, consumer, x2, y2, z2, true);
    }

    private void addVertexShader(Matrix4f pose, VertexConsumer consumer, float x, float y, float z, boolean isBorder) {
        consumer.m_252986_(pose, x, y, z);
        if (isBorder) {
            consumer.m_6122_(255, 255, 255, 255);
        } else {
            consumer.m_6122_(0, 0, 0, 0);
        }
        consumer.m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
    }

    public int m_142163_() {
        return 256;
    }
}

