/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.TickableInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstancingController;
import com.jozufozu.flywheel.core.model.BlockModel;
import com.jozufozu.flywheel.core.model.Model;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.mayaqq.estrogen.client.registry.EstrogenRenderer;
import dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock.DreamBlockRenderer;
import dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock.flywheel.DreamData;
import dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock.texture.advanced.DynamicDreamTexture;
import dev.mayaqq.estrogen.registry.blockEntities.DreamBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DreamBlockInstance
extends BlockEntityInstance<DreamBlockEntity>
implements TickableInstance {
    public static final BlockEntityInstancingController<DreamBlockEntity> CONTROLLER = new Controller();
    private static final ThreadLocal<BufferBuilder> LOCAL_BUILDER = ThreadLocal.withInitial(() -> new BufferBuilder(256));
    protected DreamData data;

    public DreamBlockInstance(MaterialManager materialManager, DreamBlockEntity blockEntity) {
        super(materialManager, (BlockEntity)blockEntity);
    }

    public void init() {
        DynamicDreamTexture.INSTANCE.prepare();
        if (((DreamBlockEntity)this.blockEntity).getTexture() != null) {
            ((DreamBlockEntity)this.blockEntity).setTexture(null);
        }
        this.data = (DreamData)this.materialManager.cutout(DynamicDreamTexture.INSTANCE.getRenderType()).material(EstrogenRenderer.DREAM).model((Object)this.blockState, this::buildModel).createInstance();
        this.data.setPosition(this.getInstancePosition()).setBlockLight(15).setSkyLight(15);
    }

    protected Model buildModel() {
        BufferBuilder builder = LOCAL_BUILDER.get();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        this.face((VertexConsumer)builder, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, Direction.SOUTH);
        this.face((VertexConsumer)builder, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Direction.NORTH);
        this.face((VertexConsumer)builder, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, Direction.EAST);
        this.face((VertexConsumer)builder, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, Direction.WEST);
        this.face((VertexConsumer)builder, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, Direction.DOWN);
        this.face((VertexConsumer)builder, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, Direction.UP);
        BufferBuilder.RenderedBuffer buffer = builder.m_231175_();
        BlockModel model = new BlockModel(buffer.m_231196_(), buffer.m_231197_(), buffer.m_231198_(), -1, "dream_block");
        buffer.m_231200_();
        return model;
    }

    private void face(VertexConsumer builder, float x0, float x1, float y0, float y1, float z0, float z1, float z2, float z3, Direction direction) {
        this.addInnerVertex(builder, x0, y0, z0);
        this.addInnerVertex(builder, x1, y0, z1);
        this.addInnerVertex(builder, x1, y1, z2);
        this.addInnerVertex(builder, x0, y1, z3);
        if (!((DreamBlockEntity)this.blockEntity).isTouchingDreamBlock(direction)) {
            this.addOuterVertex(builder, x0, y1, z3);
            this.addOuterVertex(builder, x1, y1, z2);
            this.addOuterVertex(builder, x1, y0, z1);
            this.addOuterVertex(builder, x0, y0, z0);
        }
    }

    private void addInnerVertex(VertexConsumer builder, float x, float y, float z) {
        float x2 = ((DreamBlockEntity)this.blockEntity).isTouchingDreamBlock((double)x > 0.5 ? Direction.EAST : Direction.WEST) ? x : x * 7.0f / 8.0f + 0.0625f;
        float y2 = ((DreamBlockEntity)this.blockEntity).isTouchingDreamBlock((double)y > 0.5 ? Direction.UP : Direction.DOWN) ? y : y * 7.0f / 8.0f + 0.0625f;
        float z2 = ((DreamBlockEntity)this.blockEntity).isTouchingDreamBlock((double)z > 0.5 ? Direction.SOUTH : Direction.NORTH) ? z : z * 7.0f / 8.0f + 0.0625f;
        this.addVertex(builder, x2, y2, z2, false);
    }

    private void addOuterVertex(VertexConsumer builder, float x, float y, float z) {
        float x2 = x * 0.999f + 5.0E-4f;
        float y2 = y * 0.999f + 5.0E-4f;
        float z2 = z * 0.999f + 5.0E-4f;
        this.addVertex(builder, x2, y2, z2, true);
    }

    private void addVertex(VertexConsumer builder, float x, float y, float z, boolean isBorder) {
        builder.m_5483_((double)x, (double)y, (double)z);
        if (isBorder) {
            builder.m_193479_(-1);
        } else {
            builder.m_193479_(0);
        }
        builder.m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
    }

    protected void remove() {
        this.data.delete();
    }

    public void tick() {
        DynamicDreamTexture.setActive();
    }

    public boolean decreaseTickRateWithDistance() {
        return false;
    }

    private static class Controller
    implements BlockEntityInstancingController<DreamBlockEntity> {
        private Controller() {
        }

        public BlockEntityInstance<? super DreamBlockEntity> createInstance(MaterialManager materialManager, DreamBlockEntity blockEntity) {
            return DreamBlockRenderer.useAdvancedRenderer() ? new DreamBlockInstance(materialManager, blockEntity) : null;
        }

        public boolean shouldSkipRender(DreamBlockEntity blockEntity) {
            return DreamBlockRenderer.useAdvancedRenderer();
        }
    }
}

