/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.cosmetics.ui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import dev.mayaqq.estrogen.client.cosmetics.Cosmetic;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CosmeticIconWidget
extends AbstractSimiWidget {
    public static final PartPose DEFAULT_POSE = PartPose.m_171430_((float)30.0f, (float)225.0f, (float)0.0f);
    private static final Vector3f LIGHT_0 = new Vector3f(0.2f, -1.0f, -0.5f).normalize();
    private static final Vector3f LIGHT_1 = new Vector3f(-0.8f, -1.0f, 1.0f).normalize();
    private PartPose pose;
    private Cosmetic cosmetic;
    private ContentScaling contentScalingMode = ContentScaling.NONE;
    private HighlightPredicate hoverPredicate;
    private float scale = 0.5f;
    private float rotationSpeed;
    private boolean overrideAnimationSetting = false;
    private final LerpedFloat overlayAnimation = LerpedFloat.linear();
    private boolean isHovered;
    private float animRot;
    public boolean debug;

    public CosmeticIconWidget(Cosmetic cosmetic, int x, int y, int width, int height, @Nullable PartPose referencePose) {
        super(x, y, width, height);
        this.cosmetic = cosmetic;
        this.pose = referencePose != null ? referencePose : DEFAULT_POSE;
        this.z = 150.0f;
        this.defaultHighlightPredicate();
    }

    public static CosmeticIconWidget of(Cosmetic cosmetic) {
        return new CosmeticIconWidget(cosmetic, 0, 0, 0, 0, null);
    }

    protected void beforeRender(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.beforeRender(graphics, mouseX, mouseY, partialTicks);
        if (!this.f_93624_) {
            return;
        }
        boolean hover = this.hoverPredicate.test(this, mouseX, mouseY);
        if (hover != this.isHovered) {
            this.isHovered = hover;
            this.overlayAnimation.startWithValue(hover ? 0.0 : 1.0);
            this.overlayAnimation.chase(hover ? 1.0 : 0.0, 0.6, LerpedFloat.Chaser.EXP);
            this.overlayAnimation.tickChaser();
        }
    }

    protected void doRender(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrices = graphics.m_280168_();
        matrices.m_252880_((float)this.m_252754_(), (float)(this.m_252907_() + 16), this.z);
        Vector3fc modelSize = this.cosmetic.model().getModelSize();
        Vector2f modelScale = this.contentScalingMode.calculate(this.f_93618_, this.f_93619_, modelSize);
        matrices.m_252880_(0.0f, (float)this.f_93619_ - modelSize.y(), 0.0f);
        matrices.m_85841_(16.0f * modelScale.x, -16.0f * modelScale.y, 16.0f * modelScale.x);
        if (this.pose.f_171405_ != 0.0f || this.pose.f_171406_ != 0.0f || this.pose.f_171407_ != 0.0f) {
            matrices.m_252880_(this.pose.f_171405_ / 16.0f, this.pose.f_171406_ / 16.0f, this.pose.f_171407_ / 16.0f);
        }
        if (this.rotateOrScale()) {
            matrices.m_252880_(0.5f, 0.5f, 0.5f);
            matrices.m_85841_(this.scale, this.scale, this.scale);
            matrices.m_252781_(this.rotateXYZ(this.pose.f_171408_, this.pose.f_171409_, this.pose.f_171410_));
            if (this.rotationSpeed != 0.0f && (this.overrideAnimationSetting || this.cosmetic.useDefaultAnimation())) {
                matrices.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)this.animRot, (float)(this.animRot + this.rotationSpeed))));
            }
            matrices.m_252880_(-0.5f, -0.5f, -0.5f);
        }
        if (this.debug) {
            this.drawDebugBounds(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -1);
            this.drawDebugBounds(this.m_252754_(), this.m_252907_(), (float)this.m_252754_() + modelSize.x(), (float)this.m_252907_() + modelSize.y(), -65536);
        }
        float animation = this.overlayAnimation.getValue(partialTicks);
        int overlay = this.isHovered || !this.overlayAnimation.settled() ? OverlayTexture.m_118090_((float)(animation * 0.5f), (boolean)false) : OverlayTexture.f_118083_;
        RenderSystem.setShaderLights((Vector3f)LIGHT_0, (Vector3f)LIGHT_1);
        this.cosmetic.render(RenderType::m_110452_, (MultiBufferSource)graphics.m_280091_(), matrices, 0xF000F0, overlay);
        graphics.m_280262_();
    }

    private void drawDebugBounds(float minX, float minY, float maxX, float maxY, int color) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_5483_((double)minX, (double)minY, 0.0).m_193479_(color).m_5752_();
        builder.m_5483_((double)minX, (double)maxY, 0.0).m_193479_(color).m_5752_();
        builder.m_5483_((double)maxX, (double)maxY, 0.0).m_193479_(color).m_5752_();
        builder.m_5483_((double)maxX, (double)minY, 0.0).m_193479_(color).m_5752_();
        Tesselator.m_85913_().m_85914_();
        RenderSystem.disableBlend();
    }

    public void tick() {
        if (this.rotationSpeed > 0.0f && (this.overrideAnimationSetting || this.cosmetic.useDefaultAnimation())) {
            this.animRot += this.rotationSpeed;
            if (this.animRot >= 360.0f) {
                this.animRot = 0.0f;
            }
        }
        this.overlayAnimation.tickChaser();
    }

    public CosmeticIconWidget overrideAnimationSetting() {
        this.overrideAnimationSetting = true;
        return this;
    }

    public CosmeticIconWidget withRotationSpeed(float speed) {
        this.rotationSpeed = speed;
        return this;
    }

    public CosmeticIconWidget withScale(float scale) {
        this.scale = scale;
        return this;
    }

    public CosmeticIconWidget withSize(int width, int height) {
        this.f_93618_ = width;
        this.f_93619_ = height;
        return this;
    }

    public CosmeticIconWidget withContentScaling(ContentScaling mode) {
        this.contentScalingMode = mode;
        return this;
    }

    public CosmeticIconWidget withPose(PartPose pose) {
        this.pose = pose;
        return this;
    }

    public CosmeticIconWidget withHighlightPredicate(HighlightPredicate predicate) {
        this.hoverPredicate = predicate;
        return this;
    }

    public CosmeticIconWidget defaultHighlightPredicate() {
        this.hoverPredicate = HighlightPredicate.DEFAULT;
        return this;
    }

    public CosmeticIconWidget neverHighlight() {
        return this.withHighlightPredicate(($0, $1, $2) -> false);
    }

    public CosmeticIconWidget withDefaultPose() {
        this.pose = DEFAULT_POSE;
        return this;
    }

    public CosmeticIconWidget debug() {
        this.debug = true;
        return this;
    }

    public boolean rotateOrScale() {
        return this.pose.f_171408_ != 0.0f || this.pose.f_171409_ != 0.0f || this.pose.f_171410_ != 0.0f || this.scale != 1.0f || this.rotationSpeed != 0.0f || this.animRot != 0.0f;
    }

    public void setCosmetic(Cosmetic cosmetic) {
        this.cosmetic = cosmetic;
    }

    private Quaternionf rotateXYZ(float x, float y, float z) {
        return new Quaternionf().rotateXYZ(x * ((float)Math.PI / 180), y * ((float)Math.PI / 180), z * ((float)Math.PI / 180));
    }

    private void applyContentScaling() {
    }

    @FunctionalInterface
    public static interface ContentScaling {
        public static final ContentScaling NONE = (width, height, modelSize) -> new Vector2f(1.0f, 1.0f);
        public static final ContentScaling SCALE_X = (width, height, modelSize) -> new Vector2f(width / modelSize.x(), width / modelSize.x());
        public static final ContentScaling SCALE_Y = (width, height, modelSize) -> new Vector2f(height / modelSize.y(), height / modelSize.y());
        public static final ContentScaling AUTO = (width, height, modelSize) -> modelSize.x() > modelSize.y() ? SCALE_Y.calculate(width, height, modelSize) : SCALE_X.calculate(width, height, modelSize);
        public static final ContentScaling SQUISH = (width, height, modelSize) -> new Vector2f(width / modelSize.x(), height / modelSize.y());

        public Vector2f calculate(float var1, float var2, Vector3fc var3);
    }

    @FunctionalInterface
    public static interface HighlightPredicate {
        public static final HighlightPredicate DEFAULT = (self, mouseX, mouseY) -> mouseX >= self.m_252754_() && mouseX <= self.m_252754_() + self.f_93618_ && mouseY >= self.m_252907_() && mouseY <= self.m_252907_() + self.f_93619_;

        public boolean test(CosmeticIconWidget var1, int var2, int var3);
    }
}

