/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.cosmetics.ui;

import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import dev.mayaqq.estrogen.Estrogen;
import dev.mayaqq.estrogen.client.cosmetics.Cosmetic;
import dev.mayaqq.estrogen.client.cosmetics.service.CosmeticsApi;
import dev.mayaqq.estrogen.client.cosmetics.ui.BaseCosmeticsScreen;
import dev.mayaqq.estrogen.client.cosmetics.ui.CosmeticUI;
import dev.mayaqq.estrogen.client.cosmetics.ui.widgets.CosmeticIconWidget;
import dev.mayaqq.estrogen.client.cosmetics.ui.widgets.ImprovedBoxWidget;
import dev.mayaqq.estrogen.client.cosmetics.ui.widgets.LayoutGroup;
import dev.mayaqq.estrogen.client.cosmetics.ui.widgets.UIComponents;
import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class CosmeticsScreen
extends BaseCosmeticsScreen {
    public static final URI PATREON_URI = URI.create("https://www.patreon.com/mayaqq");

    public CosmeticsScreen(Screen parent) {
        super(parent);
    }

    @Override
    protected void contentInit(int x, int y, int width, int height) {
        ArrayList<Cosmetic> cosmetics = new ArrayList<Cosmetic>();
        cosmetics.add(null);
        for (String s : CosmeticsApi.getAvailableCosmetics()) {
            Cosmetic cosmetic = CosmeticsApi.getCosmetic(s);
            if (cosmetic == null) continue;
            cosmetics.add(cosmetic);
        }
        GridLayout.RowHelper layout = new GridLayout(x, y).m_267612_(20).m_264606_(width / 52);
        if (cosmetics.size() == 1) {
            int buttonWidth = 200;
            int buttonHeight = 32;
            int centerX = x + width / 2 - buttonWidth / 2;
            int centerY = y + height / 2 - buttonHeight / 2;
            UIComponents.textButton(CosmeticUI.NO_COSMETICS).withSize(buttonWidth, buttonHeight).withPosition(centerX, centerY).withTooltip((Component)CosmeticUI.PATREON_LINK).withBounds(buttonWidth, buttonHeight).withCallback(this::openPatreon).m_264134_(arg_0 -> ((CosmeticsScreen)this).m_142416_(arg_0));
        }
        for (Cosmetic cosmetic : cosmetics) {
            LayoutGroup group = new LayoutGroup(32, 32);
            if (cosmetic != null) {
                ImprovedBoxWidget button = (ImprovedBoxWidget)UIComponents.button().withSize(32, 32).withTooltip((Component)Component.m_237113_((String)cosmetic.name())).withCallback(() -> CosmeticsApi.setCosmetic(cosmetic));
                group.addChild((LayoutElement)button);
                group.addChild((LayoutElement)CosmeticIconWidget.of(cosmetic).withSize(32, 32).withContentScaling(CosmeticIconWidget.ContentScaling.AUTO).withHighlightPredicate((widget, mouseX, mouseY) -> button.m_274382_()).withRotationSpeed(0.5f));
            } else {
                group.addChild((LayoutElement)UIComponents.iconButton((ScreenElement)AllIcons.I_CONFIG_RESET).withSize(32, 32).withTooltip((Component)CosmeticUI.NONE).withPadding(0.0f, 0.0f).withCallback(() -> CosmeticsApi.setCosmetic(null)));
            }
            layout.m_264139_((LayoutElement)group);
        }
        layout.m_267613_().m_264036_();
        layout.m_267613_().m_264134_(arg_0 -> ((CosmeticsScreen)this).m_142416_(arg_0));
    }

    public void openPatreon() {
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(PATREON_URI);
            } else {
                Estrogen.LOGGER.error("Desktop is not supported. Please open the link manually: {}", (Object)PATREON_URI);
            }
        }
        catch (Exception e) {
            Estrogen.LOGGER.error("Failed to open Patreon link", (Throwable)e);
        }
    }
}

