/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.cosmetics.service;

import com.teamresourceful.resourcefulcosmetics.ResourcefulCosmetics;
import com.teamresourceful.resourcefulcosmetics.errors.BadRequestException;
import com.teamresourceful.resourcefulcosmetics.errors.ForbiddenException;
import com.teamresourceful.resourcefulcosmetics.errors.InternalServerException;
import com.teamresourceful.resourcefulcosmetics.errors.NotFoundException;
import com.teamresourceful.resourcefulcosmetics.errors.UnauthorizedException;
import dev.mayaqq.estrogen.Estrogen;
import dev.mayaqq.estrogen.client.cosmetics.Cosmetic;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Optionull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import org.jetbrains.annotations.Nullable;

public class CosmeticsApi {
    private static final ResourcefulCosmetics<Cosmetic> API = ResourcefulCosmetics.create((String)"https://estrogen-cosmetics.teamresourceful.com/", Cosmetic::fromJson, error -> Estrogen.LOGGER.error("Failed to load cosmetics", (Throwable)error));

    public static void init() {
    }

    private static CompletableFuture<StatusCode> tryApiCall(TryApiCall runnable) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                runnable.run();
                return StatusCode.OK;
            }
            catch (BadRequestException e) {
                return StatusCode.BAD_REQUEST;
            }
            catch (ForbiddenException e) {
                return StatusCode.FORBIDDEN;
            }
            catch (InternalServerException e) {
                return StatusCode.INTERNAL_SERVER_ERROR;
            }
            catch (NotFoundException e) {
                return StatusCode.NOT_FOUND;
            }
            catch (UnauthorizedException e) {
                return StatusCode.UNAUTHORIZED;
            }
            catch (Exception e) {
                Estrogen.LOGGER.error("Failed to call API", (Throwable)e);
                return StatusCode.UNKNOWN_ERROR;
            }
        });
    }

    private static UUID getProfileId() {
        return Minecraft.m_91087_().m_91094_().m_240411_();
    }

    public static CompletableFuture<StatusCode> login() {
        return CosmeticsApi.tryApiCall(() -> {
            User user = Minecraft.m_91087_().m_91094_();
            String serverId = UUID.randomUUID().toString();
            Minecraft.m_91087_().m_91108_().joinServer(user.m_92548_(), user.m_92547_(), serverId);
            API.login(user.m_240411_(), user.m_92546_(), serverId);
        });
    }

    public static CompletableFuture<StatusCode> getCosmetics() {
        return CosmeticsApi.tryApiCall(() -> API.getCosmetics(CosmeticsApi.getProfileId(), false));
    }

    public static CompletableFuture<StatusCode> setCosmetic(@Nullable Cosmetic cosmetic) {
        return CosmeticsApi.tryApiCall(() -> API.setCosmetic(CosmeticsApi.getProfileId(), (String)Optionull.m_269382_((Object)cosmetic, Cosmetic::id)));
    }

    public static CompletableFuture<StatusCode> claimReward(String code) {
        return CosmeticsApi.tryApiCall(() -> API.claimCosmetic(CosmeticsApi.getProfileId(), code));
    }

    public static boolean hasSessionToken() {
        return API.hasSession(Minecraft.m_91087_().m_91094_().m_240411_());
    }

    public static List<String> getAvailableCosmetics() {
        try {
            return API.getCosmetics(CosmeticsApi.getProfileId(), true).available();
        }
        catch (Exception e) {
            return List.of();
        }
    }

    public static Cosmetic getCosmetic(String id) {
        return (Cosmetic)API.getCosmetic(id);
    }

    public static Cosmetic getCosmetic(UUID id) {
        return (Cosmetic)API.getSelectedCosmetic(id);
    }

    @FunctionalInterface
    private static interface TryApiCall {
        public void run() throws Exception;
    }

    public static enum StatusCode {
        OK,
        BAD_REQUEST,
        FORBIDDEN,
        UNAUTHORIZED,
        NOT_FOUND,
        INTERNAL_SERVER_ERROR,
        UNKNOWN_ERROR;

    }
}

