/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.cosmetics.model.mesh;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.mayaqq.estrogen.client.cosmetics.model.CosmeticModelBakery;
import dev.mayaqq.estrogen.client.cosmetics.model.mesh.Mesh;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public record SimpleMesh(int[] data, int vertexCount) implements Mesh
{
    @Override
    public void renderInto(VertexConsumer consumer, @NotNull PoseStack transform, int color, int light, int overlay) {
        Vector4f position = new Vector4f();
        Vector3f normal = new Vector3f();
        PoseStack.Pose pose = transform.m_85850_();
        for (int vertex = 0; vertex < this.vertexCount; ++vertex) {
            int pos = 6 * vertex;
            float x = Float.intBitsToFloat(this.data[pos]);
            float y = Float.intBitsToFloat(this.data[pos + 1]);
            float z = Float.intBitsToFloat(this.data[pos + 2]);
            float u = Float.intBitsToFloat(this.data[pos + 3]);
            float v = Float.intBitsToFloat(this.data[pos + 4]);
            int packedNormal = this.data[pos + 5];
            position.set(x, y, z, 1.0f);
            CosmeticModelBakery.unpackNormal(packedNormal, normal);
            position.mul((Matrix4fc)pose.m_252922_());
            normal.mul((Matrix3fc)pose.m_252943_());
            consumer.m_5954_(position.x, position.y, position.z, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >>> 24) / 255.0f, u, v, overlay, light, normal.x, normal.y, normal.z);
        }
    }
}

