/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.cosmetics.model.mesh;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.mayaqq.estrogen.client.cosmetics.model.animation.Animatable;
import dev.mayaqq.estrogen.client.cosmetics.model.mesh.Mesh;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.Optionull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MeshTree
implements Mesh,
Animatable,
Animatable.Provider {
    private float x;
    private float y;
    private float z;
    private float xRot;
    private float yRot;
    private float zRot;
    private float xScale = 1.0f;
    private float yScale = 1.0f;
    private float zScale = 1.0f;
    private final Vector3f origin;
    private final Mesh mesh;
    private final Map<String, MeshTree> children;

    public MeshTree(Mesh mesh, Vector3f origin, Map<String, MeshTree> children) {
        this.mesh = mesh;
        this.origin = origin;
        this.children = children;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void offsetPosition(Vector3fc offset) {
        this.x = offset.x();
        this.y = offset.y();
        this.z = offset.z();
    }

    @Override
    public void offsetRotation(Vector3fc offset) {
        this.xRot = offset.x();
        this.yRot = offset.y();
        this.zRot = offset.z();
    }

    @Override
    public void offsetScale(Vector3fc offset) {
        this.xScale = offset.x();
        this.yScale = offset.y();
        this.zScale = offset.z();
    }

    @Override
    public void reset() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.zRot = 0.0f;
        this.yRot = 0.0f;
        this.xRot = 0.0f;
        this.zScale = 1.0f;
        this.yScale = 1.0f;
        this.xScale = 1.0f;
    }

    public void applyTransform(PoseStack poseStack) {
        poseStack.m_252880_(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f);
        poseStack.m_252880_(this.origin.x, this.origin.y, this.origin.z);
        if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
            poseStack.m_252781_(new Quaternionf().rotationXYZ(this.xRot, this.yRot, this.zRot));
        }
        if (this.xScale != 1.0f || this.yScale != 1.0f || this.zScale != 1.0f) {
            poseStack.m_85841_(this.xScale, this.yScale, this.zScale);
        }
        poseStack.m_252880_(-this.origin.x, -this.origin.y, -this.origin.z);
    }

    @Override
    public void renderInto(VertexConsumer consumer, PoseStack transform, int color, int light, int overlay) {
        this.applyTransform(transform);
        this.mesh.renderInto(consumer, transform, color, light, overlay);
        for (MeshTree child : this.children.values()) {
            transform.m_85836_();
            child.renderInto(consumer, transform, color, light, overlay);
            transform.m_85849_();
        }
    }

    public MeshTree getChild(String name) {
        return this.children.get(name);
    }

    public void traverse(BiConsumer<String, MeshTree> visitor) {
        this.traverse("root", visitor);
    }

    protected void traverse(String name, BiConsumer<String, MeshTree> visitor) {
        visitor.accept(name, this);
        for (Map.Entry<String, MeshTree> entry : this.children.entrySet()) {
            String childName = name + "/" + entry.getKey();
            entry.getValue().traverse(childName, visitor);
        }
    }

    @Override
    public Optional<Animatable> getAny(String name) {
        return (Optional)Optionull.m_269543_((Object)this.children.get(name), Optional::of, () -> this.children.entrySet().stream().flatMap(entry -> ((MeshTree)entry.getValue()).getAny(name).stream()).findAny());
    }

    @Override
    public int vertexCount() {
        return this.mesh.vertexCount();
    }

    public static class Builder {
        private Mesh mesh = Mesh.EMPTY;
        private Vector3f origin;
        private final Map<String, MeshTree> children = new Object2ObjectArrayMap();

        private Builder() {
        }

        public Builder mesh(Mesh mesh) {
            this.mesh = mesh;
            return this;
        }

        public Builder origin(Vector3f origin) {
            this.origin = origin;
            return this;
        }

        public Builder addChild(String name, MeshTree child) {
            this.children.put(name, child);
            return this;
        }

        public MeshTree build() {
            if (this.origin == null) {
                this.origin = new Vector3f();
            }
            return new MeshTree(this.mesh, this.origin, this.children);
        }
    }
}

