/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.cosmetics.model;

import com.mojang.math.Axis;
import dev.mayaqq.estrogen.client.cosmetics.model.BakedCosmeticModel;
import dev.mayaqq.estrogen.client.cosmetics.model.BlockElementGroup;
import dev.mayaqq.estrogen.client.cosmetics.model.PreparedModel;
import dev.mayaqq.estrogen.client.cosmetics.model.mesh.MeshTree;
import dev.mayaqq.estrogen.client.cosmetics.model.mesh.SimpleMesh;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.FaceInfo;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@ParametersAreNonnullByDefault
public final class CosmeticModelBakery {
    private static final float RESCALE_22_5 = 1.0f / (float)Math.cos((double)0.3926991f) - 1.0f;
    private static final float RESCALE_45 = 1.0f / (float)Math.cos((double)0.7853981852531433) - 1.0f;
    private static final float PACK = 127.0f;
    private static final float UNPACK = 0.007874016f;
    private final PreparedModel model;
    private final Vector3f minBound = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
    private final Vector3f maxBound = new Vector3f();
    private final Vector4f position = new Vector4f();
    private final Vector3f normal = new Vector3f();
    private final Matrix4f modelMat = new Matrix4f();
    private final Matrix3f normalMat = new Matrix3f();

    public CosmeticModelBakery(PreparedModel model) {
        this.model = model;
    }

    public static BakedCosmeticModel bake(PreparedModel model) {
        CosmeticModelBakery bakery = new CosmeticModelBakery(model);
        return model.hasGroups() ? bakery.bakeGrouped() : bakery.bakeSimple();
    }

    public BakedCosmeticModel bakeSimple() {
        return new BakedCosmeticModel(this.bakeMesh(this.model.elements()), this.minBound, this.maxBound);
    }

    public BakedCosmeticModel bakeGrouped() {
        List<BlockElement> elements = this.model.elements();
        MeshTree.Builder builder = MeshTree.builder();
        IntSet ungrouped = IntStream.range(0, elements.size()).collect(() -> CosmeticModelBakery.createIntSet(elements.size()), IntCollection::add, IntCollection::addAll);
        for (BlockElementGroup rootGroup : this.model.groups()) {
            builder.addChild(rootGroup.name(), this.compileGroup(rootGroup, index -> {
                if (!ungrouped.remove(index)) {
                    throw new IllegalStateException("Element #%d referenced in multiple groups".formatted(index));
                }
                return (BlockElement)elements.get(index);
            }));
        }
        if (!ungrouped.isEmpty()) {
            builder.mesh(this.bakeMesh(ungrouped.intStream().mapToObj(elements::get).toList()));
        }
        return new BakedCosmeticModel(builder.build(), this.minBound, this.maxBound);
    }

    public MeshTree compileGroup(BlockElementGroup group, IntFunction<BlockElement> elementGetter) {
        List<BlockElement> elements = group.elementIndices().intStream().mapToObj(elementGetter).toList();
        MeshTree.Builder builder = MeshTree.builder().mesh(this.bakeMesh(elements)).origin(new Vector3f((Vector3fc)group.origin()).div(16.0f));
        for (BlockElementGroup subGroup : group.subGroups()) {
            builder.addChild(subGroup.name(), this.compileGroup(subGroup, elementGetter));
        }
        return builder.build();
    }

    public SimpleMesh bakeMesh(List<BlockElement> elements) {
        int vertices = elements.stream().mapToInt(e -> e.f_111310_.size()).sum() * 4;
        int[] vertexData = new int[vertices * 6];
        int index = 0;
        for (BlockElement element : elements) {
            this.modelMat.identity();
            this.normalMat.identity();
            float[] shape = CosmeticModelBakery.setupShape(element.f_111308_, element.f_111309_);
            BlockElementRotation rot = element.f_111311_;
            if (rot != null) {
                this.applyElementRotation(rot, this.modelMat, this.normalMat);
            }
            for (Map.Entry entry : element.f_111310_.entrySet()) {
                Direction direction = (Direction)entry.getKey();
                BlockFaceUV uv = ((BlockElementFace)entry.getValue()).f_111357_;
                FaceInfo face = FaceInfo.m_108984_((Direction)direction);
                for (int i = 0; i < 4; ++i) {
                    FaceInfo.VertexInfo vertex = face.m_108982_(i);
                    this.position.set(shape[vertex.f_108998_], shape[vertex.f_108999_], shape[vertex.f_109000_], 1.0f);
                    this.modelMat.transform(this.position);
                    float u = uv.m_111392_(i) / 16.0f;
                    float v = uv.m_111396_(i) / 16.0f;
                    this.normal.set((float)direction.m_122429_(), (float)direction.m_122430_(), (float)direction.m_122431_());
                    this.normalMat.transform(this.normal);
                    int pos = index * 6;
                    vertexData[pos] = Float.floatToRawIntBits(this.position.x);
                    vertexData[pos + 1] = Float.floatToRawIntBits(this.position.y);
                    vertexData[pos + 2] = Float.floatToRawIntBits(this.position.z);
                    vertexData[pos + 3] = Float.floatToRawIntBits(u);
                    vertexData[pos + 4] = Float.floatToRawIntBits(v);
                    vertexData[pos + 5] = CosmeticModelBakery.packNormal(this.normal.x, this.normal.y, this.normal.z);
                    this.minBound.set(Math.min((float)this.minBound.x, (float)this.position.x), Math.min((float)this.minBound.y, (float)this.position.y), Math.min((float)this.minBound.z, (float)this.position.z));
                    this.maxBound.set(Math.max((float)this.maxBound.x, (float)this.position.x), Math.max((float)this.maxBound.y, (float)this.position.y), Math.max((float)this.maxBound.z, (float)this.position.z));
                    ++index;
                }
            }
        }
        return new SimpleMesh(vertexData, vertices);
    }

    private static float[] setupShape(Vector3f min, Vector3f max) {
        float[] fs = new float[Direction.values().length];
        fs[FaceInfo.Constants.f_108996_] = min.x() / 16.0f;
        fs[FaceInfo.Constants.f_108995_] = min.y() / 16.0f;
        fs[FaceInfo.Constants.f_108994_] = min.z() / 16.0f;
        fs[FaceInfo.Constants.f_108993_] = max.x() / 16.0f;
        fs[FaceInfo.Constants.f_108992_] = max.y() / 16.0f;
        fs[FaceInfo.Constants.f_108991_] = max.z() / 16.0f;
        return fs;
    }

    private void applyElementRotation(BlockElementRotation rotation, Matrix4f modelMat, Matrix3f normalMat) {
        Vector3f origin = rotation.f_111378_();
        modelMat.translate(origin.x / 16.0f, origin.y / 16.0f, origin.z / 16.0f);
        Quaternionf quat = this.axisRotation(rotation.f_111379_(), rotation.f_111380_());
        modelMat.rotate((Quaternionfc)quat);
        normalMat.rotate((Quaternionfc)quat);
        if (rotation.f_111381_()) {
            Vector3f scale = this.getRescaleVector(rotation.f_111379_());
            scale.mul(Math.abs((float)rotation.f_111380_()) == 22.5f ? RESCALE_22_5 : RESCALE_45);
            modelMat.scale(scale.x, scale.y, scale.z);
            float nx = 1.0f / scale.x;
            float ny = 1.0f / scale.y;
            float nz = 1.0f / scale.z;
            float i = Mth.m_14199_((float)(nx * ny * nz));
            normalMat.scale(nx * i, ny * i, nz * i);
        }
        modelMat.translate(-(origin.x / 16.0f), -(origin.y / 16.0f), -(origin.z / 16.0f));
    }

    private Vector3f getRescaleVector(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vector3f(0.0f, 1.0f, 1.0f);
            case Direction.Axis.Y -> new Vector3f(1.0f, 0.0f, 1.0f);
            case Direction.Axis.Z -> new Vector3f(1.0f, 1.0f, 0.0f);
        };
    }

    private Quaternionf axisRotation(Direction.Axis axis, float degrees) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> Axis.f_252529_.m_252977_(degrees);
            case Direction.Axis.Y -> Axis.f_252436_.m_252977_(degrees);
            case Direction.Axis.Z -> Axis.f_252403_.m_252977_(degrees);
        };
    }

    public static int packNormal(float x, float y, float z) {
        x = Mth.m_14036_((float)x, (float)-1.0f, (float)1.0f);
        y = Mth.m_14036_((float)y, (float)-1.0f, (float)1.0f);
        z = Mth.m_14036_((float)z, (float)-1.0f, (float)1.0f);
        return (int)(x * 127.0f) & 0xFF | ((int)(y * 127.0f) & 0xFF) << 8 | ((int)(z * 127.0f) & 0xFF) << 16;
    }

    public static float unpackNX(int packedNormal) {
        return (float)((byte)(packedNormal & 0xFF)) * 0.007874016f;
    }

    public static float unpackNY(int packedNormal) {
        return (float)((byte)(packedNormal >>> 8 & 0xFF)) * 0.007874016f;
    }

    public static float unpackNZ(int packedNormal) {
        return (float)((byte)(packedNormal >>> 16 & 0xFF)) * 0.007874016f;
    }

    public static Vector3f unpackNormal(int packedNormal, Vector3f dest) {
        dest.set(CosmeticModelBakery.unpackNX(packedNormal), CosmeticModelBakery.unpackNY(packedNormal), CosmeticModelBakery.unpackNZ(packedNormal));
        return dest;
    }

    private static IntSet createIntSet(int size) {
        return size > 4 ? new IntOpenHashSet() : new IntArraySet();
    }
}

