/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.cosmetics.model;

import com.jozufozu.flywheel.core.model.BlockModel;
import com.jozufozu.flywheel.core.model.Model;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.mayaqq.estrogen.client.cosmetics.model.animation.AnimationDefinition;
import dev.mayaqq.estrogen.client.cosmetics.model.animation.Animations;
import dev.mayaqq.estrogen.client.cosmetics.model.mesh.Mesh;
import dev.mayaqq.estrogen.client.cosmetics.model.mesh.MeshTree;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.joml.Math;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BakedCosmeticModel {
    private static final ThreadLocal<BufferBuilder> LOCAL_BUILDER = ThreadLocal.withInitial(() -> new BufferBuilder(512));
    protected final Mesh mesh;
    private final Vector3f minBound;
    private final Vector3f maxBound;
    private final Vector3f animCache = new Vector3f();

    public BakedCosmeticModel(Mesh mesh, Vector3f minBound, Vector3f maxBound) {
        this.mesh = mesh;
        this.minBound = minBound;
        this.maxBound = maxBound;
    }

    public void runAnimation(AnimationDefinition definition) {
        Mesh mesh = this.mesh;
        if (mesh instanceof MeshTree) {
            MeshTree tree = (MeshTree)mesh;
            tree.reset();
            Animations.animate(tree, definition, this.animCache);
        }
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public Vector3fc getMinBound() {
        return this.minBound;
    }

    public Vector3fc getMaxBound() {
        return this.maxBound;
    }

    public Vector3f computeModelSize() {
        Vector3f vec = new Vector3f((Vector3fc)this.maxBound).sub((Vector3fc)this.minBound);
        vec.set(Math.max((float)vec.x, (float)1.0f), Math.max((float)vec.y, (float)1.0f), Math.max((float)vec.z, (float)1.0f));
        vec.mul(16.0f);
        return vec;
    }

    public Model createModel() {
        BufferBuilder builder = LOCAL_BUILDER.get();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        this.mesh.renderInto((VertexConsumer)builder, new PoseStack(), -1, 0, OverlayTexture.f_118083_);
        BufferBuilder.RenderedBuffer buffer = builder.m_231175_();
        BlockModel model = new BlockModel(buffer.m_231196_(), buffer.m_231197_(), buffer.m_231198_(), 0, "cosmetic");
        buffer.m_231200_();
        return model;
    }
}

