/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.config;

import com.jozufozu.flywheel.backend.Backend;
import com.teamresourceful.resourcefullib.common.network.Packet;
import dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock.texture.advanced.DynamicDreamTexture;
import dev.mayaqq.estrogen.config.ChestConfig;
import dev.mayaqq.estrogen.config.DreamBlockRenderState;
import dev.mayaqq.estrogen.config.EstrogenConfig;
import dev.mayaqq.estrogen.networking.EstrogenNetworkManager;
import dev.mayaqq.estrogen.networking.messages.c2s.SetChestConfigPacket;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigSync {
    private static ChestConfig cache;
    private static DreamBlockRenderState lastRenderValue;

    public static void cacheConfig() {
        cache = ConfigSync.currentConfig();
        lastRenderValue = (DreamBlockRenderState)((Object)EstrogenConfig.client().advancedRendering.get());
    }

    public static void onLoad(ModConfig modConfig) {
        if (EstrogenConfig.client().specification == modConfig.getSpec()) {
            ConfigSync.cacheConfig();
        }
    }

    public static void onReload(ModConfig modConfig) {
        if (EstrogenConfig.client().specification == modConfig.getSpec()) {
            DreamBlockRenderState useAdvancedRender;
            ChestConfig config = ConfigSync.currentConfig();
            if (cache == null || !cache.equals(config)) {
                ConfigSync.sendConfig(config);
                cache = config;
            }
            if ((useAdvancedRender = (DreamBlockRenderState)((Object)EstrogenConfig.client().advancedRendering.get())) != lastRenderValue) {
                Backend.reloadWorldRenderers();
                lastRenderValue = useAdvancedRender;
            }
            DynamicDreamTexture.enableAnimation = (Boolean)EstrogenConfig.client().animateTexture.get();
        }
    }

    private static ChestConfig currentConfig() {
        return new ChestConfig((Boolean)EstrogenConfig.client().chestFeature.get(), (Boolean)EstrogenConfig.client().chestArmor.get(), (Boolean)EstrogenConfig.client().chestPhysics.get(), ((Double)EstrogenConfig.client().chestBounciness.get()).floatValue(), ((Double)EstrogenConfig.client().chestDamping.get()).floatValue());
    }

    private static void sendConfig(ChestConfig config) {
        if (Minecraft.m_91087_().m_91403_() == null) {
            return;
        }
        EstrogenNetworkManager.CHANNEL.sendToServer((Packet)new SetChestConfigPacket(config));
    }

    public static void sendCurrentConfig() {
        EstrogenNetworkManager.CHANNEL.sendToServer((Packet)new SetChestConfigPacket(ConfigSync.currentConfig()));
    }
}

