/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.inventory.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.inventory.client.GuiMGUButton;
import mob_grinding_utils.inventory.client.MGUScreen;
import mob_grinding_utils.inventory.server.ContainerAbsorptionHopper;
import mob_grinding_utils.network.MessageAbsorptionHopper;
import mob_grinding_utils.tile.TileEntityAbsorptionHopper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;

public class GuiAbsorptionHopper
extends MGUScreen<ContainerAbsorptionHopper> {
    protected final ContainerAbsorptionHopper container;
    private final TileEntityAbsorptionHopper tile;
    private final Player player;

    public GuiAbsorptionHopper(ContainerAbsorptionHopper container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title, new ResourceLocation("mob_grinding_utils:textures/gui/absorption_hopper_gui.png"));
        this.container = container;
        this.tile = this.container.hopper;
        this.player = playerInventory.f_35978_;
        this.f_97727_ = 226;
        this.f_97726_ = 248;
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        Button.OnPress message = button -> {
            if (button instanceof GuiMGUButton) {
                MobGrindingUtils.NETWORK_WRAPPER.sendToServer((Object)new MessageAbsorptionHopper(this.player, ((GuiMGUButton)button).id, this.tile.m_58899_()));
            }
        };
        this.m_142416_((GuiEventListener)new GuiMGUButton(this.f_97735_ + 7, this.f_97736_ + 17, GuiMGUButton.Size.MEDIUM, 0, (Component)Component.m_237113_((String)"Down"), message));
        this.m_142416_((GuiEventListener)new GuiMGUButton(this.f_97735_ + 7, this.f_97736_ + 34, GuiMGUButton.Size.MEDIUM, 1, (Component)Component.m_237113_((String)"Up"), message));
        this.m_142416_((GuiEventListener)new GuiMGUButton(this.f_97735_ + 7, this.f_97736_ + 51, GuiMGUButton.Size.MEDIUM, 2, (Component)Component.m_237113_((String)"North"), message));
        this.m_142416_((GuiEventListener)new GuiMGUButton(this.f_97735_ + 82, this.f_97736_ + 17, GuiMGUButton.Size.MEDIUM, 3, (Component)Component.m_237113_((String)"South"), message));
        this.m_142416_((GuiEventListener)new GuiMGUButton(this.f_97735_ + 82, this.f_97736_ + 34, GuiMGUButton.Size.MEDIUM, 4, (Component)Component.m_237113_((String)"West"), message));
        this.m_142416_((GuiEventListener)new GuiMGUButton(this.f_97735_ + 82, this.f_97736_ + 51, GuiMGUButton.Size.MEDIUM, 5, (Component)Component.m_237113_((String)"East"), message));
        this.m_142416_((GuiEventListener)new GuiMGUButton(this.f_97735_ + 173, this.f_97736_ + 113, GuiMGUButton.Size.LARGE, 6, (Component)Component.m_237119_(), button -> {
            MobGrindingUtils.NETWORK_WRAPPER.sendToServer((Object)new MessageAbsorptionHopper(this.player, 6, this.tile.m_58899_()));
            this.tile.showRenderBox = !this.tile.showRenderBox;
        }));
        this.m_142416_((GuiEventListener)new GuiMGUButton(this.f_97735_ + 173, this.f_97736_ + 25, GuiMGUButton.Size.SMALL, 7, (Component)Component.m_237113_((String)"-"), message));
        this.m_142416_((GuiEventListener)new GuiMGUButton(this.f_97735_ + 225, this.f_97736_ + 25, GuiMGUButton.Size.SMALL, 8, (Component)Component.m_237113_((String)"+"), message));
        this.m_142416_((GuiEventListener)new GuiMGUButton(this.f_97735_ + 173, this.f_97736_ + 59, GuiMGUButton.Size.SMALL, 9, (Component)Component.m_237113_((String)"-"), message));
        this.m_142416_((GuiEventListener)new GuiMGUButton(this.f_97735_ + 225, this.f_97736_ + 59, GuiMGUButton.Size.SMALL, 10, (Component)Component.m_237113_((String)"+"), message));
        this.m_142416_((GuiEventListener)new GuiMGUButton(this.f_97735_ + 173, this.f_97736_ + 93, GuiMGUButton.Size.SMALL, 11, (Component)Component.m_237113_((String)"-"), message));
        this.m_142416_((GuiEventListener)new GuiMGUButton(this.f_97735_ + 225, this.f_97736_ + 93, GuiMGUButton.Size.SMALL, 12, (Component)Component.m_237113_((String)"+"), message));
    }

    @Override
    protected void m_280003_(GuiGraphics gg, int mouseX, int mouseY) {
        gg.m_280614_(this.f_96547_, this.m_96636_(), 8, 6, 0x404040, false);
        gg.m_280056_(this.f_96547_, Component.m_237115_((String)"block.mob_grinding_utils.absorption_hopper_d_u").getString(), 174, 14, 0x404040, false);
        gg.m_280056_(this.f_96547_, Component.m_237115_((String)"block.mob_grinding_utils.absorption_hopper_n_s").getString(), 174, 48, 0x404040, false);
        gg.m_280056_(this.f_96547_, Component.m_237115_((String)"block.mob_grinding_utils.absorption_hopper_w_e").getString(), 174, 82, 0x404040, false);
        gg.drawString(this.f_96547_, !this.tile.showRenderBox ? "Show Area" : "Hide Area", 207.0f - (float)this.f_96547_.m_92895_(!this.tile.showRenderBox ? "Show Area" : "Hide Area") / 2.0f, 117.0f, 0xE0E0E0, true);
        TileEntityAbsorptionHopper.EnumStatus DOWN = this.tile.getSideStatus(Direction.DOWN);
        TileEntityAbsorptionHopper.EnumStatus UP = this.tile.getSideStatus(Direction.UP);
        TileEntityAbsorptionHopper.EnumStatus NORTH = this.tile.getSideStatus(Direction.NORTH);
        TileEntityAbsorptionHopper.EnumStatus SOUTH = this.tile.getSideStatus(Direction.SOUTH);
        TileEntityAbsorptionHopper.EnumStatus WEST = this.tile.getSideStatus(Direction.WEST);
        TileEntityAbsorptionHopper.EnumStatus EAST = this.tile.getSideStatus(Direction.EAST);
        gg.m_280137_(this.f_96547_, DOWN.m_7912_(), 58, 21, this.getModeColour(DOWN.ordinal()));
        gg.m_280137_(this.f_96547_, UP.m_7912_(), 58, 38, this.getModeColour(UP.ordinal()));
        gg.m_280137_(this.f_96547_, NORTH.m_7912_(), 58, 55, this.getModeColour(NORTH.ordinal()));
        gg.m_280137_(this.f_96547_, SOUTH.m_7912_(), 133, 21, this.getModeColour(SOUTH.ordinal()));
        gg.m_280137_(this.f_96547_, WEST.m_7912_(), 133, 38, this.getModeColour(WEST.ordinal()));
        gg.m_280137_(this.f_96547_, EAST.m_7912_(), 133, 55, this.getModeColour(EAST.ordinal()));
        gg.m_280137_(this.f_96547_, String.valueOf(this.tile.getoffsetY()), 207, 29, 5285857);
        gg.m_280137_(this.f_96547_, String.valueOf(this.tile.getoffsetZ()), 207, 63, 5285857);
        gg.m_280137_(this.f_96547_, String.valueOf(this.tile.getoffsetX()), 207, 97, 5285857);
    }

    @Override
    protected void m_7286_(GuiGraphics gg, float partialTicks, int mouseX, int mouseY) {
        boolean zLevel = false;
        gg.m_280218_(this.TEX, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int fluid = this.tile.getScaledFluid(120);
        if (fluid >= 1) {
            IClientFluidTypeExtensions fluidExtensions = IClientFluidTypeExtensions.of((Fluid)this.tile.tank.getFluid().getFluid());
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidExtensions.getStillTexture());
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder buffer = tessellator.m_85915_();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            buffer.m_5483_((double)(this.f_97735_ + 156), (double)(this.f_97736_ + 128), (double)zLevel).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_5752_();
            buffer.m_5483_((double)(this.f_97735_ + 168), (double)(this.f_97736_ + 128), (double)zLevel).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_5752_();
            buffer.m_5483_((double)(this.f_97735_ + 168), (double)(this.f_97736_ + 128 - fluid), (double)zLevel).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_5752_();
            buffer.m_5483_((double)(this.f_97735_ + 156), (double)(this.f_97736_ + 128 - fluid), (double)zLevel).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_5752_();
            tessellator.m_85914_();
        }
        gg.m_280218_(this.TEX, this.f_97735_ + 153, this.f_97736_ + 8, 248, 0, 6, 120);
    }

    public int getModeColour(int index) {
        return switch (index) {
            case 0 -> 0xFF0000;
            case 1 -> 5285857;
            case 2 -> 0xFFFF00;
            default -> 0xFFFF00;
        };
    }
}

