/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager.trades;

import com.almostreliable.morejs.features.villager.TradeItem;
import com.almostreliable.morejs.features.villager.trades.TransformableTrade;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class StewTrade
extends TransformableTrade<StewTrade> {
    protected MobEffect[] effects;
    protected int duration;

    public StewTrade(TradeItem[] inputs, MobEffect[] effects, int duration) {
        super(inputs);
        for (MobEffect effect : effects) {
            if (effect != null) continue;
            throw new IllegalArgumentException("Null effect in effects array: " + Arrays.toString(effects));
        }
        Preconditions.checkArgument((duration > 0 ? 1 : 0) != 0, (Object)"Duration must be greater than 0");
        this.effects = effects;
        this.duration = duration;
    }

    @Override
    @Nullable
    public MerchantOffer createOffer(Entity entity, RandomSource random) {
        ItemStack stew = new ItemStack((ItemLike)Items.f_42718_);
        for (MobEffect effect : this.effects) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)effect, (int)this.duration);
        }
        return this.createOffer(stew, random);
    }
}

