/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.worker;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class ToggleRecipeMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private int recipeLocation;
    private int id;

    public ToggleRecipeMessage() {
    }

    public ToggleRecipeMessage(@NotNull IBuildingView building, int location, int id) {
        super(building);
        this.recipeLocation = location;
        this.id = id;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.recipeLocation = buf.readInt();
        this.id = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.recipeLocation);
        buf.writeInt(this.id);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        if (building.getModule(this.id) != null) {
            AbstractCraftingBuildingModule module = (AbstractCraftingBuildingModule)building.getModule(this.id);
            module.toggle(this.recipeLocation);
        }
    }
}

