/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.items.ItemResourceScroll;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceScrollSaveWarehouseSnapshotMessage
implements IMessage {
    private BlockPos builderPos;
    @NotNull
    private Map<String, Integer> snapshot = new HashMap<String, Integer>();
    @NotNull
    private String workOrderHash = "";

    public ResourceScrollSaveWarehouseSnapshotMessage() {
    }

    public ResourceScrollSaveWarehouseSnapshotMessage(BlockPos builderPos) {
        this(builderPos, Map.of(), "");
    }

    public ResourceScrollSaveWarehouseSnapshotMessage(BlockPos builderPos, @NotNull Map<String, Integer> snapshot, @NotNull String workOrderHash) {
        this.builderPos = builderPos;
        this.snapshot = snapshot;
        this.workOrderHash = workOrderHash;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.builderPos = buf.m_130135_();
        }
        int numItems = buf.readInt();
        this.snapshot = new HashMap<String, Integer>();
        for (int i = 0; i < numItems; ++i) {
            String itemName = buf.m_130136_(Short.MAX_VALUE);
            int itemAmount = buf.readInt();
            this.snapshot.put(itemName, itemAmount);
        }
        this.workOrderHash = buf.m_130136_(Short.MAX_VALUE);
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.writeBoolean(this.builderPos != null);
        if (this.builderPos != null) {
            buf.m_130064_(this.builderPos);
        }
        buf.writeInt(this.snapshot.size());
        this.snapshot.forEach((key, value) -> {
            buf.m_130070_(key);
            buf.writeInt(value.intValue());
        });
        buf.m_130070_(this.workOrderHash);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        Objects.requireNonNull(ctxIn.getSender()).m_150109_().f_35974_.stream().filter(stack -> stack.m_41720_() instanceof ItemResourceScroll).filter(stack -> stack.m_41783_() != null).filter(stack -> Objects.equals(this.builderPos, BlockPosUtil.read(stack.m_41783_(), "builder"))).forEach(stack -> {
            CompoundTag data = stack.m_41783_();
            CompoundTag newData = new CompoundTag();
            this.snapshot.keySet().forEach(f -> newData.m_128405_(f, this.snapshot.getOrDefault(f, 0).intValue()));
            data.m_128365_("version", (Tag)newData);
            data.m_128359_("wo_hash", this.workOrderHash);
        });
    }
}

